/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ErrorDescription;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;

public class CloudFoundryApiException
extends RuntimeException {
    @Nullable
    private ErrorDescription.Code errorCode;

    public CloudFoundryApiException(ErrorDescription errorCause) {
        super((String)Optional.ofNullable(errorCause).map(e -> CloudFoundryApiException.getMessage(e.getErrors().toArray(new String[0]))).orElse(null));
        if (errorCause != null) {
            this.errorCode = errorCause.getCode();
        }
    }

    public CloudFoundryApiException(Throwable t, String ... errors) {
        super(CloudFoundryApiException.getMessage(t, errors), t);
    }

    public CloudFoundryApiException(String ... errors) {
        super(CloudFoundryApiException.getMessage(errors));
    }

    private static String getMessage(String ... errors) {
        return "Cloud Foundry API returned with error(s): " + Arrays.stream(errors).filter(Objects::nonNull).collect(Collectors.joining(" and "));
    }

    private static String getMessage(Throwable t, String ... errors) {
        String[] allErrors = Arrays.copyOf(errors, errors.length + 1);
        allErrors[errors.length] = t.getMessage();
        return CloudFoundryApiException.getMessage(allErrors);
    }

    @Nullable
    @Generated
    public ErrorDescription.Code getErrorCode() {
        return this.errorCode;
    }
}

