/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.api;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateUserProvidedServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Page;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Service;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServicePlan;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.SharedTo;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.UserProvidedServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateSharedServiceInstances;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ServiceInstanceService {
    @GET(value="/v2/service_instances")
    public Call<Page<ServiceInstance>> all(@Query(value="page") Integer var1, @Query(value="q") List<String> var2);

    @GET(value="/v2/user_provided_service_instances")
    public Call<Page<UserProvidedServiceInstance>> allUserProvided(@Query(value="page") Integer var1, @Query(value="q") List<String> var2);

    @GET(value="/v2/services")
    public Call<Page<Service>> findService(@Query(value="page") Integer var1, @Query(value="q") List<String> var2);

    @GET(value="/v2/service_plans/{guid}")
    public Call<Resource<ServicePlan>> findServicePlanByServicePlanId(@Path(value="guid") String var1);

    @GET(value="/v2/services/{guid}")
    public Call<Resource<Service>> findServiceByServiceId(@Path(value="guid") String var1);

    @GET(value="/v2/spaces/{guid}/services")
    public Call<Page<Service>> findServiceBySpaceId(@Path(value="guid") String var1, @Query(value="page") Integer var2, @Query(value="q") List<String> var3);

    @GET(value="/v2/service_plans")
    public Call<Page<ServicePlan>> findServicePlans(@Query(value="page") Integer var1, @Query(value="q") List<String> var2);

    @POST(value="/v2/service_instances?accepts_incomplete=true")
    public Call<Resource<ServiceInstance>> createServiceInstance(@Body CreateServiceInstance var1);

    @POST(value="/v2/user_provided_service_instances")
    public Call<Resource<UserProvidedServiceInstance>> createUserProvidedServiceInstance(@Body CreateUserProvidedServiceInstance var1);

    @PUT(value="/v2/service_instances/{guid}?accepts_incomplete=true")
    public Call<Resource<ServiceInstance>> updateServiceInstance(@Path(value="guid") String var1, @Body CreateServiceInstance var2);

    @PUT(value="/v2/user_provided_service_instances/{guid}")
    public Call<Resource<UserProvidedServiceInstance>> updateUserProvidedServiceInstance(@Path(value="guid") String var1, @Body CreateUserProvidedServiceInstance var2);

    @POST(value="/v2/service_bindings?accepts_incomplete=true")
    public Call<Resource<ServiceBinding>> createServiceBinding(@Body CreateServiceBinding var1);

    @GET(value="/v2/service_instances/{guid}/service_bindings")
    public Call<Page<ServiceBinding>> getBindingsForServiceInstance(@Path(value="guid") String var1, @Query(value="page") Integer var2, @Query(value="q") List<String> var3);

    @GET(value="/v2/user_provided_service_instances/{guid}/service_bindings")
    public Call<Page<ServiceBinding>> getBindingsForUserProvidedServiceInstance(@Path(value="guid") String var1, @Query(value="page") Integer var2, @Query(value="q") List<String> var3);

    @GET(value="/v2/service_bindings")
    public Call<Page<ServiceBinding>> getAllServiceBindings(@Query(value="q") List<String> var1);

    @DELETE(value="/v2/service_bindings/{guid}?accepts_incomplete=true")
    public Call<ResponseBody> deleteServiceBinding(@Path(value="guid") String var1);

    @DELETE(value="/v2/service_instances/{guid}?accepts_incomplete=true")
    public Call<ResponseBody> destroyServiceInstance(@Path(value="guid") String var1);

    @DELETE(value="/v2/user_provided_service_instances/{guid}")
    public Call<ResponseBody> destroyUserProvidedServiceInstance(@Path(value="guid") String var1);

    @POST(value="/v3/service_instances/{guid}/relationships/shared_spaces")
    public Call<ResponseBody> shareServiceInstanceToSpaceIds(@Path(value="guid") String var1, @Body CreateSharedServiceInstances var2);

    @GET(value="/v3/service_instances/{guid}/relationships/shared_spaces")
    public Call<SharedTo> getShareServiceInstanceSpaceIdsByServiceInstanceId(@Path(value="guid") String var1);

    @DELETE(value="/v3/service_instances/{guid}/relationships/shared_spaces/{space_guid}")
    public Call<ResponseBody> unshareServiceInstanceFromSpaceId(@Path(value="guid") String var1, @Path(value="space_guid") String var2);
}

