/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy;

import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Application;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.helpers.AbstractServerGroupNameResolver;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class CloudFoundryServerGroupNameResolver
extends AbstractServerGroupNameResolver {
    private static final String PHASE = "DEPLOY";
    private final CloudFoundryClient client;
    private final CloudFoundrySpace space;

    public String getPhase() {
        return PHASE;
    }

    public String getRegion() {
        return this.space.getRegion();
    }

    public List<AbstractServerGroupNameResolver.TakenSlot> getTakenSlots(String clusterName) {
        return this.client.getApplications().getTakenSlots(clusterName, this.space.getId()).stream().map(app -> {
            Names names = Names.parseName((String)((Application)app.getEntity()).getName());
            return new AbstractServerGroupNameResolver.TakenSlot(names.getCluster(), names.getSequence(), Date.from(app.getMetadata().getCreatedAt().toInstant()));
        }).collect(Collectors.toList());
    }

    @Generated
    public CloudFoundryServerGroupNameResolver(CloudFoundryClient client, CloudFoundrySpace space) {
        this.client = client;
        this.space = space;
    }
}

