/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.CloudFoundryRunJobOperationDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CloudFoundryRunJobOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Map;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="runJob")
@Component
public class CloudFoundryRunJobOperationConverter
extends AbstractCloudFoundryAtomicOperationConverter {
    public AtomicOperation convertOperation(Map input) {
        return new CloudFoundryRunJobOperation(this.convertDescription(input));
    }

    public CloudFoundryRunJobOperationDescription convertDescription(Map input) {
        CloudFoundryRunJobOperationDescription converted = (CloudFoundryRunJobOperationDescription)this.getObjectMapper().convertValue((Object)input, CloudFoundryRunJobOperationDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        CloudFoundryClient client = credentials.getClient();
        converted.setClient(client);
        String jobName = (String)input.get("jobName");
        String region = (String)input.get("region");
        String serverGroupName = (String)input.get("serverGroupName");
        CloudFoundrySpace space = this.findSpace(region, client).orElseThrow(() -> new IllegalArgumentException("Unable to find organization and space '" + region + "'."));
        CloudFoundryServerGroup serverGroup = client.getApplications().findServerGroupByNameAndSpaceId(serverGroupName, space.getId());
        if (serverGroup == null) {
            throw new IllegalStateException(String.format("Can't run job '%s': CloudFoundry application '%s' not found in org/space '%s'", jobName, serverGroupName, region));
        }
        converted.setServerGroup(serverGroup);
        return converted;
    }
}

