/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DestroyCloudFoundryServiceDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.DestroyCloudFoundryServiceAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Map;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="destroyService")
@Component
public class DestroyCloudFoundryServiceAtomicOperationConverter
extends AbstractCloudFoundryAtomicOperationConverter {
    public AtomicOperation convertOperation(Map input) {
        return new DestroyCloudFoundryServiceAtomicOperation(this.convertDescription(input));
    }

    public DestroyCloudFoundryServiceDescription convertDescription(Map input) {
        DestroyCloudFoundryServiceDescription converted = (DestroyCloudFoundryServiceDescription)this.getObjectMapper().convertValue((Object)input, DestroyCloudFoundryServiceDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        converted.setClient(this.getClient(input));
        converted.setSpace(this.findSpace(converted.getRegion(), converted.getClient()).orElseThrow(() -> new IllegalArgumentException("Unable to find space '" + converted.getRegion() + "'.")));
        if (converted.getApplication() == null || converted.getApplication().isEmpty()) {
            throw new IllegalArgumentException("Application must not be null. Please re-create the destroy service stage in order to automatically add this field.");
        }
        return converted;
    }
}

