/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryServerGroupAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.ScaleCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.ScaleCloudFoundryServerGroupAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="resizeServerGroup")
@Component
public class ScaleCloudFoundryServerGroupAtomicOperationConverter
extends AbstractCloudFoundryServerGroupAtomicOperationConverter {
    private final OperationPoller operationPoller;

    public ScaleCloudFoundryServerGroupAtomicOperationConverter(@Qualifier(value="cloudFoundryOperationPoller") OperationPoller operationPoller) {
        this.operationPoller = operationPoller;
    }

    public AtomicOperation convertOperation(Map input) {
        return new ScaleCloudFoundryServerGroupAtomicOperation(this.operationPoller, this.convertDescription(input));
    }

    public ScaleCloudFoundryServerGroupDescription convertDescription(Map input) {
        ScaleCloudFoundryServerGroupDescription converted = (ScaleCloudFoundryServerGroupDescription)this.getObjectMapper().convertValue((Object)input, ScaleCloudFoundryServerGroupDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        converted.setClient(this.getClient(input));
        converted.setServerGroupId(this.getServerGroupId(converted.getServerGroupName(), converted.getRegion(), converted.getClient()));
        return converted;
    }
}

