/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.UpsertCloudFoundryLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.UpsertCloudFoundryLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Map;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="upsertLoadBalancer")
@Component
public class UpsertCloudFoundryLoadBalancerAtomicOperationConverter
extends AbstractCloudFoundryAtomicOperationConverter {
    public AtomicOperation convertOperation(Map input) {
        return new UpsertCloudFoundryLoadBalancerAtomicOperation(this.convertDescription(input));
    }

    public UpsertCloudFoundryLoadBalancerDescription convertDescription(Map input) {
        UpsertCloudFoundryLoadBalancerDescription converted = (UpsertCloudFoundryLoadBalancerDescription)this.getObjectMapper().convertValue((Object)input, UpsertCloudFoundryLoadBalancerDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        CloudFoundryClient client = this.getClient(input);
        converted.setClient(client);
        this.findSpace(converted.getRegion(), client).map(converted::setSpace).orElseThrow(() -> new IllegalArgumentException("Unable to find space '" + converted.getRegion() + "'"));
        String domainName = input.get("domain").toString();
        converted.setDomain(client.getDomains().findByName(domainName).orElseThrow(() -> new IllegalArgumentException("Unable to find domain '" + domainName + "'")));
        return converted;
    }
}

