/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeleteCloudFoundryLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class DeleteCloudFoundryLoadBalancerAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "DELETE_LOAD_BALANCER";
    private final DeleteCloudFoundryLoadBalancerDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        CloudFoundryClient client = this.description.getClient();
        if (this.description.getLoadBalancer() == null) {
            throw new CloudFoundryApiException(new String[]{"Load balancer does not exist"});
        }
        DeleteCloudFoundryLoadBalancerAtomicOperation.getTask().updateStatus(PHASE, "Deleting load balancer " + this.description.getLoadBalancer().getName());
        client.getRoutes().deleteRoute(this.description.getLoadBalancer().getId());
        DeleteCloudFoundryLoadBalancerAtomicOperation.getTask().updateStatus(PHASE, "Deleted load balancer " + this.description.getLoadBalancer().getName());
        return null;
    }

    @Generated
    public DeleteCloudFoundryLoadBalancerAtomicOperation(DeleteCloudFoundryLoadBalancerDescription description) {
        this.description = description;
    }
}

