/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.StartCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CloudFoundryOperationUtils;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class StartCloudFoundryServerGroupAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "START_SERVER_GROUP";
    private final OperationPoller operationPoller;
    private final StartCloudFoundryServerGroupDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        StartCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Starting '" + this.description.getServerGroupName() + "'");
        CloudFoundryClient client = this.description.getClient();
        client.getApplications().startApplication(this.description.getServerGroupId());
        ProcessStats.State state = (ProcessStats.State)((Object)this.operationPoller.waitForOperation(() -> client.getApplications().getAppState(this.description.getServerGroupId()), inProgressState -> inProgressState != ProcessStats.State.STARTING, null, StartCloudFoundryServerGroupAtomicOperation.getTask(), this.description.getServerGroupName(), PHASE));
        if (state != ProcessStats.State.RUNNING) {
            throw new CloudFoundryApiException(new String[]{"Failed to start '" + this.description.getServerGroupName() + "' which instead " + CloudFoundryOperationUtils.describeProcessState(state)});
        }
        StartCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Started '" + this.description.getServerGroupName() + "'");
        return null;
    }

    @Generated
    public StartCloudFoundryServerGroupAtomicOperation(OperationPoller operationPoller, StartCloudFoundryServerGroupDescription description) {
        this.operationPoller = operationPoller;
        this.description = description;
    }
}

