/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.ArtifactInfo;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryBuildInfo;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryDroplet;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryImage;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryModel;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import com.netflix.spinnaker.clouddriver.model.Image;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.names.NamerRegistry;
import com.netflix.spinnaker.moniker.Moniker;
import io.vavr.collection.HashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;

@JsonDeserialize(builder=CloudFoundryServerGroupBuilder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"loadBalancerNames"})
public final class CloudFoundryServerGroup
extends CloudFoundryModel
implements ServerGroup {
    private static final ObjectMapper IMAGE_MAPPER = new ObjectMapper();
    @JsonView(value={Views.Cache.class})
    private final String account;
    @JsonView(value={Views.Cache.class})
    private final String appsManagerUri;
    @JsonView(value={Views.Cache.class})
    private final String metricsUri;
    @JsonView(value={Views.Cache.class})
    private final String name;
    @JsonView(value={Views.Cache.class})
    private final String id;
    @JsonView(value={Views.Cache.class})
    private final Integer memory;
    @JsonView(value={Views.Cache.class})
    @Nullable
    private final CloudFoundryDroplet droplet;
    @JsonView(value={Views.Cache.class})
    private final Integer diskQuota;
    @JsonView(value={Views.Cache.class})
    @Nullable
    private final String healthCheckType;
    @JsonView(value={Views.Cache.class})
    @Nullable
    private final String healthCheckHttpEndpoint;
    @JsonView(value={Views.Cache.class})
    private final State state;
    @JsonView(value={Views.Cache.class})
    private final CloudFoundrySpace space;
    @JsonView(value={Views.Cache.class})
    private final Long updatedTime;
    @JsonView(value={Views.Cache.class})
    private final Long createdTime;
    @JsonView(value={Views.Cache.class})
    private final Map<String, Object> env;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Cache.class})
    private final List<CloudFoundryServiceInstance> serviceInstances;
    @JsonView(value={Views.Cache.class})
    private final CloudFoundryBuildInfo ciBuild;
    @JsonView(value={Views.Cache.class})
    private final ArtifactInfo appArtifact;
    @JsonView(value={Views.Cache.class})
    private final String pipelineId;
    @JsonView(value={Views.Relationship.class})
    private final Set<CloudFoundryInstance> instances;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonView(value={Views.Relationship.class})
    private final Set<String> loadBalancerNames;

    public Set<String> getLoadBalancers() {
        return this.loadBalancerNames == null ? Collections.emptySet() : this.loadBalancerNames;
    }

    public Set<CloudFoundryInstance> getInstances() {
        return this.instances == null ? Collections.emptySet() : this.instances;
    }

    public ServerGroup.ImagesSummary getImagesSummary() {
        return new ServerGroup.ImagesSummary(){

            public List<? extends ServerGroup.ImageSummary> getSummaries() {
                return Collections.singletonList(new ServerGroup.ImageSummary(){

                    public String getServerGroupName() {
                        return CloudFoundryServerGroup.this.name;
                    }

                    public String getImageName() {
                        return CloudFoundryServerGroup.this.name + "-droplet";
                    }

                    public String getImageId() {
                        return CloudFoundryServerGroup.this.droplet == null ? "unknown" : CloudFoundryServerGroup.this.droplet.getId();
                    }

                    public Map<String, Object> getImage() {
                        return (Map)IMAGE_MAPPER.convertValue((Object)this, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    }

                    public Map<String, Object> getBuildInfo() {
                        return Collections.emptyMap();
                    }
                });
            }
        };
    }

    public Image getImage() {
        return CloudFoundryImage.builder().id(this.droplet == null ? "unknown" : this.droplet.getId()).name(this.name + "-droplet").region(this.getRegion()).build();
    }

    public Map getBuildInfo() {
        return HashMap.of((Object)"appsManagerUri", (Object)this.appsManagerUri, (Object)"metricsUri", (Object)this.metricsUri, (Object)"droplet", (Object)this.droplet, (Object)"id", (Object)this.id, (Object)"serviceInstances", this.serviceInstances, (Object)"ciBuild", (Object)this.ciBuild, (Object)"appArtifact", (Object)this.appArtifact).toJavaMap();
    }

    @Deprecated
    public ServerGroup.ImageSummary getImageSummary() {
        return (ServerGroup.ImageSummary)this.getImagesSummary().getSummaries().get(0);
    }

    public String getRegion() {
        return this.space == null ? "unknown" : this.space.getRegion();
    }

    public Boolean isDisabled() {
        return this.state == State.STOPPED;
    }

    public Set<String> getZones() {
        return this.space == null ? Collections.emptySet() : Collections.singleton(this.space.getName());
    }

    public Set<String> getSecurityGroups() {
        return Collections.emptySet();
    }

    public Map<String, Object> getLaunchConfig() {
        return Collections.emptyMap();
    }

    public ServerGroup.InstanceCounts getInstanceCounts() {
        return new ServerGroup.InstanceCounts(Integer.valueOf(this.instances.size()), Integer.valueOf((int)this.instances.stream().filter(in -> HealthState.Up.equals((Object)in.getHealthState())).count()), Integer.valueOf((int)this.instances.stream().filter(in -> HealthState.Down.equals((Object)in.getHealthState())).count()), Integer.valueOf((int)this.instances.stream().filter(in -> HealthState.Unknown.equals((Object)in.getHealthState())).count()), Integer.valueOf((int)this.instances.stream().filter(in -> HealthState.OutOfService.equals((Object)in.getHealthState())).count()), Integer.valueOf((int)this.instances.stream().filter(in -> HealthState.Starting.equals((Object)in.getHealthState())).count()));
    }

    public ServerGroup.Capacity getCapacity() {
        return new ServerGroup.Capacity(Integer.valueOf(this.instances.size()), Integer.valueOf(this.instances.size()), Integer.valueOf(this.instances.size()));
    }

    public String getStack() {
        return Names.parseName((String)this.name).getStack();
    }

    public String getDetail() {
        return Names.parseName((String)this.name).getDetail();
    }

    public Moniker getMoniker() {
        Moniker moniker = NamerRegistry.getDefaultNamer().deriveMoniker((Object)this);
        return new Moniker(moniker.getApp(), moniker.getCluster(), moniker.getDetail(), moniker.getStack(), Integer.valueOf(moniker.getSequence() == null ? 0 : moniker.getSequence()));
    }

    @Deprecated
    public String getType() {
        return CloudFoundryCloudProvider.ID;
    }

    @Generated
    CloudFoundryServerGroup(String account, String appsManagerUri, String metricsUri, String name, String id, Integer memory, @Nullable CloudFoundryDroplet droplet, Integer diskQuota, @Nullable String healthCheckType, @Nullable String healthCheckHttpEndpoint, State state, CloudFoundrySpace space, Long updatedTime, Long createdTime, Map<String, Object> env, List<CloudFoundryServiceInstance> serviceInstances, CloudFoundryBuildInfo ciBuild, ArtifactInfo appArtifact, String pipelineId, Set<CloudFoundryInstance> instances, Set<String> loadBalancerNames) {
        this.account = account;
        this.appsManagerUri = appsManagerUri;
        this.metricsUri = metricsUri;
        this.name = name;
        this.id = id;
        this.memory = memory;
        this.droplet = droplet;
        this.diskQuota = diskQuota;
        this.healthCheckType = healthCheckType;
        this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
        this.state = state;
        this.space = space;
        this.updatedTime = updatedTime;
        this.createdTime = createdTime;
        this.env = env;
        this.serviceInstances = serviceInstances;
        this.ciBuild = ciBuild;
        this.appArtifact = appArtifact;
        this.pipelineId = pipelineId;
        this.instances = instances;
        this.loadBalancerNames = loadBalancerNames;
    }

    @Generated
    public static CloudFoundryServerGroupBuilder builder() {
        return new CloudFoundryServerGroupBuilder();
    }

    @Generated
    public CloudFoundryServerGroupBuilder toBuilder() {
        return new CloudFoundryServerGroupBuilder().account(this.account).appsManagerUri(this.appsManagerUri).metricsUri(this.metricsUri).name(this.name).id(this.id).memory(this.memory).droplet(this.droplet).diskQuota(this.diskQuota).healthCheckType(this.healthCheckType).healthCheckHttpEndpoint(this.healthCheckHttpEndpoint).state(this.state).space(this.space).updatedTime(this.updatedTime).createdTime(this.createdTime).env(this.env).serviceInstances(this.serviceInstances).ciBuild(this.ciBuild).appArtifact(this.appArtifact).pipelineId(this.pipelineId).instances(this.instances).loadBalancerNames(this.loadBalancerNames);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getAppsManagerUri() {
        return this.appsManagerUri;
    }

    @Generated
    public String getMetricsUri() {
        return this.metricsUri;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Integer getMemory() {
        return this.memory;
    }

    @Nullable
    @Generated
    public CloudFoundryDroplet getDroplet() {
        return this.droplet;
    }

    @Generated
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Nullable
    @Generated
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    @Nullable
    @Generated
    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    @Generated
    public State getState() {
        return this.state;
    }

    @Generated
    public CloudFoundrySpace getSpace() {
        return this.space;
    }

    @Generated
    public Long getUpdatedTime() {
        return this.updatedTime;
    }

    @Generated
    public Long getCreatedTime() {
        return this.createdTime;
    }

    @Generated
    public Map<String, Object> getEnv() {
        return this.env;
    }

    @Generated
    public List<CloudFoundryServiceInstance> getServiceInstances() {
        return this.serviceInstances;
    }

    @Generated
    public CloudFoundryBuildInfo getCiBuild() {
        return this.ciBuild;
    }

    @Generated
    public ArtifactInfo getAppArtifact() {
        return this.appArtifact;
    }

    @Generated
    public String getPipelineId() {
        return this.pipelineId;
    }

    @Generated
    public Set<String> getLoadBalancerNames() {
        return this.loadBalancerNames;
    }

    @Generated
    public String toString() {
        return "CloudFoundryServerGroup(account=" + this.getAccount() + ", appsManagerUri=" + this.getAppsManagerUri() + ", metricsUri=" + this.getMetricsUri() + ", name=" + this.getName() + ", id=" + this.getId() + ", memory=" + this.getMemory() + ", droplet=" + this.getDroplet() + ", diskQuota=" + this.getDiskQuota() + ", healthCheckType=" + this.getHealthCheckType() + ", healthCheckHttpEndpoint=" + this.getHealthCheckHttpEndpoint() + ", state=" + this.getState() + ", space=" + this.getSpace() + ", updatedTime=" + this.getUpdatedTime() + ", createdTime=" + this.getCreatedTime() + ", env=" + this.getEnv() + ", serviceInstances=" + this.getServiceInstances() + ", ciBuild=" + this.getCiBuild() + ", appArtifact=" + this.getAppArtifact() + ", pipelineId=" + this.getPipelineId() + ", instances=" + this.getInstances() + ", loadBalancerNames=" + this.getLoadBalancerNames() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryServerGroup)) {
            return false;
        }
        CloudFoundryServerGroup other = (CloudFoundryServerGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudFoundryServerGroup;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public CloudFoundryServerGroup withServiceInstances(List<CloudFoundryServiceInstance> serviceInstances) {
        return this.serviceInstances == serviceInstances ? this : new CloudFoundryServerGroup(this.account, this.appsManagerUri, this.metricsUri, this.name, this.id, this.memory, this.droplet, this.diskQuota, this.healthCheckType, this.healthCheckHttpEndpoint, this.state, this.space, this.updatedTime, this.createdTime, this.env, serviceInstances, this.ciBuild, this.appArtifact, this.pipelineId, this.instances, this.loadBalancerNames);
    }

    @Generated
    public CloudFoundryServerGroup withInstances(Set<CloudFoundryInstance> instances) {
        return this.instances == instances ? this : new CloudFoundryServerGroup(this.account, this.appsManagerUri, this.metricsUri, this.name, this.id, this.memory, this.droplet, this.diskQuota, this.healthCheckType, this.healthCheckHttpEndpoint, this.state, this.space, this.updatedTime, this.createdTime, this.env, this.serviceInstances, this.ciBuild, this.appArtifact, this.pipelineId, instances, this.loadBalancerNames);
    }

    @Generated
    public CloudFoundryServerGroup withLoadBalancerNames(Set<String> loadBalancerNames) {
        return this.loadBalancerNames == loadBalancerNames ? this : new CloudFoundryServerGroup(this.account, this.appsManagerUri, this.metricsUri, this.name, this.id, this.memory, this.droplet, this.diskQuota, this.healthCheckType, this.healthCheckHttpEndpoint, this.state, this.space, this.updatedTime, this.createdTime, this.env, this.serviceInstances, this.ciBuild, this.appArtifact, this.pipelineId, this.instances, loadBalancerNames);
    }

    @Generated
    public static class CloudFoundryServerGroupBuilder {
        @Generated
        private String account;
        @Generated
        private String appsManagerUri;
        @Generated
        private String metricsUri;
        @Generated
        private String name;
        @Generated
        private String id;
        @Generated
        private Integer memory;
        @Generated
        private CloudFoundryDroplet droplet;
        @Generated
        private Integer diskQuota;
        @Generated
        private String healthCheckType;
        @Generated
        private String healthCheckHttpEndpoint;
        @Generated
        private State state;
        @Generated
        private CloudFoundrySpace space;
        @Generated
        private Long updatedTime;
        @Generated
        private Long createdTime;
        @Generated
        private Map<String, Object> env;
        @Generated
        private List<CloudFoundryServiceInstance> serviceInstances;
        @Generated
        private CloudFoundryBuildInfo ciBuild;
        @Generated
        private ArtifactInfo appArtifact;
        @Generated
        private String pipelineId;
        @Generated
        private Set<CloudFoundryInstance> instances;
        @Generated
        private Set<String> loadBalancerNames;

        @Generated
        CloudFoundryServerGroupBuilder() {
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder account(String account) {
            this.account = account;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder appsManagerUri(String appsManagerUri) {
            this.appsManagerUri = appsManagerUri;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder metricsUri(String metricsUri) {
            this.metricsUri = metricsUri;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder droplet(@Nullable CloudFoundryDroplet droplet) {
            this.droplet = droplet;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder diskQuota(Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder healthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder state(State state) {
            this.state = state;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder space(CloudFoundrySpace space) {
            this.space = space;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder updatedTime(Long updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder createdTime(Long createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder env(Map<String, Object> env) {
            this.env = env;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder serviceInstances(List<CloudFoundryServiceInstance> serviceInstances) {
            this.serviceInstances = serviceInstances;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder ciBuild(CloudFoundryBuildInfo ciBuild) {
            this.ciBuild = ciBuild;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder appArtifact(ArtifactInfo appArtifact) {
            this.appArtifact = appArtifact;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryServerGroupBuilder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            return this;
        }

        @JsonView(value={Views.Relationship.class})
        @Generated
        public CloudFoundryServerGroupBuilder instances(Set<CloudFoundryInstance> instances) {
            this.instances = instances;
            return this;
        }

        @JsonView(value={Views.Relationship.class})
        @Generated
        public CloudFoundryServerGroupBuilder loadBalancerNames(Set<String> loadBalancerNames) {
            this.loadBalancerNames = loadBalancerNames;
            return this;
        }

        @Generated
        public CloudFoundryServerGroup build() {
            return new CloudFoundryServerGroup(this.account, this.appsManagerUri, this.metricsUri, this.name, this.id, this.memory, this.droplet, this.diskQuota, this.healthCheckType, this.healthCheckHttpEndpoint, this.state, this.space, this.updatedTime, this.createdTime, this.env, this.serviceInstances, this.ciBuild, this.appArtifact, this.pipelineId, this.instances, this.loadBalancerNames);
        }

        @Generated
        public String toString() {
            return "CloudFoundryServerGroup.CloudFoundryServerGroupBuilder(account=" + this.account + ", appsManagerUri=" + this.appsManagerUri + ", metricsUri=" + this.metricsUri + ", name=" + this.name + ", id=" + this.id + ", memory=" + this.memory + ", droplet=" + this.droplet + ", diskQuota=" + this.diskQuota + ", healthCheckType=" + this.healthCheckType + ", healthCheckHttpEndpoint=" + this.healthCheckHttpEndpoint + ", state=" + this.state + ", space=" + this.space + ", updatedTime=" + this.updatedTime + ", createdTime=" + this.createdTime + ", env=" + this.env + ", serviceInstances=" + this.serviceInstances + ", ciBuild=" + this.ciBuild + ", appArtifact=" + this.appArtifact + ", pipelineId=" + this.pipelineId + ", instances=" + this.instances + ", loadBalancerNames=" + this.loadBalancerNames + ")";
        }
    }

    public static enum State {
        STOPPED,
        STARTED;

    }
}

