/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.security;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.CacheRepository;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.HttpCloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.config.CloudFoundryConfigurationProperties;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.security.AbstractAccountCredentials;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(value={"credentials", "client", "password", "spaceSupplier", "cacheRepository", "forkJoinPool", "filteredSpaces", "spacesLive"})
public class CloudFoundryCredentials
extends AbstractAccountCredentials<CloudFoundryClient> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudFoundryCredentials.class);
    private static final int SPACE_EXPIRY_SECONDS = 30;
    private final String name;
    private final String appsManagerUri;
    private final String metricsUri;
    private final String apiHost;
    private final String userName;
    private final String password;
    private final boolean skipSslValidation;
    private final boolean onlySpinnakerManaged;
    @Nullable
    private final String environment;
    @Nullable
    private final Integer resultsPerPage;
    private final String accountType = "cloudfoundry";
    private final String cloudProvider = "cloudfoundry";
    @Deprecated
    private final List<String> requiredGroupMembership = Collections.emptyList();
    private final Supplier<List<CloudFoundrySpace>> spaceSupplier = Memoizer.memoizeWithExpiration(this::spaceSupplier, 30L, TimeUnit.SECONDS);
    private final CacheRepository cacheRepository;
    private final Permissions permissions;
    private final ForkJoinPool forkJoinPool;
    private final List<CloudFoundrySpace> filteredSpaces;
    private final CloudFoundryClient cloudFoundryClient;

    public CloudFoundryCredentials(String name, String appsManagerUri, String metricsUri, String apiHost, String userName, String password, String environment, boolean skipSslValidation, boolean onlySpinnakerManaged, Integer resultsPerPage, CacheRepository cacheRepository, Permissions permissions, ForkJoinPool forkJoinPool, Map<String, Set<String>> spaceFilter, OkHttpClient okHttpClient, CloudFoundryConfigurationProperties.ClientConfig clientConfig, CloudFoundryConfigurationProperties.LocalCacheConfig localCacheConfig) {
        this.name = name;
        this.appsManagerUri = appsManagerUri;
        this.metricsUri = metricsUri;
        this.apiHost = apiHost;
        this.userName = userName;
        this.password = password;
        this.environment = Optional.ofNullable(environment).orElse("dev");
        this.skipSslValidation = skipSslValidation;
        this.onlySpinnakerManaged = onlySpinnakerManaged;
        this.resultsPerPage = Optional.ofNullable(resultsPerPage).orElse(100);
        this.cacheRepository = cacheRepository;
        this.permissions = permissions == null ? Permissions.EMPTY : permissions;
        this.forkJoinPool = forkJoinPool;
        this.cloudFoundryClient = new HttpCloudFoundryClient(name, appsManagerUri, metricsUri, apiHost, userName, password, true, skipSslValidation, onlySpinnakerManaged, resultsPerPage, forkJoinPool, okHttpClient.newBuilder(), clientConfig, localCacheConfig);
        this.filteredSpaces = this.createFilteredSpaces(spaceFilter);
    }

    public CloudFoundryClient getCredentials() {
        return this.getClient();
    }

    public CloudFoundryClient getClient() {
        return this.cloudFoundryClient;
    }

    public Collection<Map<String, String>> getRegions() {
        return this.spaceSupplier.get().stream().filter(s -> {
            if (!this.filteredSpaces.isEmpty()) {
                List filteredRegions = this.filteredSpaces.stream().map(CloudFoundrySpace::getRegion).collect(Collectors.toList());
                return filteredRegions.contains(s.getRegion());
            }
            return true;
        }).map(space -> Collections.singletonMap("name", space.getRegion())).collect(Collectors.toList());
    }

    protected List<CloudFoundrySpace> spaceSupplier() {
        Set<CloudFoundrySpace> spaces = this.cacheRepository.findSpacesByAccount(this.name);
        if (!spaces.isEmpty()) {
            return new ArrayList<CloudFoundrySpace>(spaces);
        }
        return this.getSpacesLive();
    }

    private List<CloudFoundrySpace> getSpacesLive() {
        try {
            return this.getClient().getSpaces().all();
        }
        catch (CloudFoundryApiException e) {
            log.warn("Unable to determine regions for Cloud Foundry account " + this.name, (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CloudFoundryCredentials)) {
            return false;
        }
        CloudFoundryCredentials that = (CloudFoundryCredentials)((Object)o);
        return this.name.equals(that.name) && Objects.equals(this.appsManagerUri, that.appsManagerUri) && Objects.equals(this.metricsUri, that.metricsUri) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.environment, that.environment) && Objects.equals(this.skipSslValidation, that.skipSslValidation) && Objects.equals(this.resultsPerPage, that.resultsPerPage);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.appsManagerUri, this.metricsUri, this.userName, this.password, this.environment, this.skipSslValidation, this.resultsPerPage);
    }

    protected List<CloudFoundrySpace> createFilteredSpaces(Map<String, Set<String>> spaceFilter) {
        ArrayList<CloudFoundrySpace> spaces = new ArrayList<CloudFoundrySpace>();
        if (spaceFilter.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<CallSite> filteredRegions = new HashSet<CallSite>();
        for (String orgName : spaceFilter.keySet()) {
            if (spaceFilter.get(orgName).isEmpty() || spaceFilter.get(orgName) == null) {
                List<CloudFoundrySpace> allSpacesByOrg = this.getClient().getSpaces().findAllBySpaceNamesAndOrgNames(null, Collections.singletonList(orgName));
                spaces.addAll(allSpacesByOrg);
                continue;
            }
            for (String spaceName : spaceFilter.get(orgName)) {
                filteredRegions.add((CallSite)((Object)(orgName + " > " + spaceName)));
            }
        }
        List<CloudFoundrySpace> allSpaces = this.getClient().getSpaces().findAllBySpaceNamesAndOrgNames(spaceFilter.values().stream().flatMap(Collection::stream).collect(Collectors.toList()), List.copyOf(spaceFilter.keySet()));
        allSpaces.stream().filter(s -> filteredRegions.contains(s.getRegion())).forEach(spaces::add);
        if (spaces.isEmpty()) {
            throw new IllegalArgumentException("The spaceFilter had Orgs and/or Spaces but CloudFoundry returned no spaces as a result. Spaces must not be null or empty when a spaceFilter is included.");
        }
        return ImmutableList.copyOf(spaces);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getAppsManagerUri() {
        return this.appsManagerUri;
    }

    @Generated
    public String getMetricsUri() {
        return this.metricsUri;
    }

    @Generated
    public String getApiHost() {
        return this.apiHost;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public boolean isSkipSslValidation() {
        return this.skipSslValidation;
    }

    @Generated
    public boolean isOnlySpinnakerManaged() {
        return this.onlySpinnakerManaged;
    }

    @Nullable
    @Generated
    public String getEnvironment() {
        return this.environment;
    }

    @Nullable
    @Generated
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Generated
    public String getAccountType() {
        Objects.requireNonNull(this);
        return "cloudfoundry";
    }

    @Generated
    public String getCloudProvider() {
        Objects.requireNonNull(this);
        return "cloudfoundry";
    }

    @Deprecated
    @Generated
    public List<String> getRequiredGroupMembership() {
        return this.requiredGroupMembership;
    }

    @Generated
    public Supplier<List<CloudFoundrySpace>> getSpaceSupplier() {
        return this.spaceSupplier;
    }

    @Generated
    public CacheRepository getCacheRepository() {
        return this.cacheRepository;
    }

    @Generated
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Generated
    public ForkJoinPool getForkJoinPool() {
        return this.forkJoinPool;
    }

    @Generated
    public List<CloudFoundrySpace> getFilteredSpaces() {
        return this.filteredSpaces;
    }

    private static class Memoizer<T>
    implements Supplier<T> {
        private static final String CACHE_KEY = "key";
        private final LoadingCache<String, T> cache;

        private Memoizer(Supplier<T> supplier, long expirySeconds, TimeUnit timeUnit) {
            this.cache = Caffeine.newBuilder().refreshAfterWrite(expirySeconds, timeUnit).build(key -> supplier.get());
        }

        public static <U> Memoizer<U> memoizeWithExpiration(Supplier<U> supplier, long expirySeconds, TimeUnit timeUnit) {
            return new Memoizer<U>(supplier, expirySeconds, timeUnit);
        }

        @Override
        public T get() {
            return (T)this.cache.get((Object)CACHE_KEY);
        }
    }
}

