/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.security;

import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.CloudFoundryProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent.CloudFoundryLoadBalancerCachingAgent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent.CloudFoundryServerGroupCachingAgent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent.CloudFoundrySpaceCachingAgent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.credentials.CredentialsLifecycleHandler;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryCredentialsLifecycleHandler
implements CredentialsLifecycleHandler<CloudFoundryCredentials> {
    private static final Logger log = LoggerFactory.getLogger(CloudFoundryCredentialsLifecycleHandler.class);
    private final CloudFoundryProvider provider;
    private final Registry registry;

    public void credentialsAdded(CloudFoundryCredentials credentials) {
        log.info("Adding agents for new account {}", (Object)credentials.getName());
        this.provider.addAgents(this.agentsForCredentials(credentials));
    }

    public void credentialsUpdated(CloudFoundryCredentials credentials) {
        log.info("Refreshing agents for updated account {}", (Object)credentials.getName());
        this.provider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
        this.provider.addAgents(this.agentsForCredentials(credentials));
    }

    public void credentialsDeleted(CloudFoundryCredentials credentials) {
        log.info("Removing agents for deleted account {}", (Object)credentials.getName());
        this.provider.removeAgentsForAccounts(Collections.singleton(credentials.getName()));
    }

    private List<Agent> agentsForCredentials(CloudFoundryCredentials credentials) {
        return List.of(new CloudFoundryServerGroupCachingAgent(credentials, this.registry), new CloudFoundryLoadBalancerCachingAgent(credentials, this.registry), new CloudFoundrySpaceCachingAgent(credentials, this.registry));
    }

    @Generated
    public CloudFoundryCredentialsLifecycleHandler(CloudFoundryProvider provider, Registry registry) {
        this.provider = provider;
        this.registry = registry;
    }
}

