/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.cache;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryCluster;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;

@Repository
public class CacheRepository {
    private final ObjectMapper objectMapper = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    private final Cache cacheView;

    public CacheRepository(Cache cacheView) {
        this.cacheView = cacheView;
        this.objectMapper.setConfig(this.objectMapper.getSerializationConfig().withView(Views.Cache.class)).setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){

            public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
                return new JsonPOJOBuilder.Value("build", "");
            }
        });
    }

    public Set<CloudFoundrySpace> findSpacesByAccount(String account) {
        return this.cacheView.getAll(Keys.Namespace.SPACES.getNs(), this.cacheView.filterIdentifiers(Keys.Namespace.SPACES.getNs(), Keys.getAllSpacesKey(account))).stream().map(spaceData -> (CloudFoundrySpace)this.objectMapper.convertValue(spaceData.getAttributes().get("resource"), CloudFoundrySpace.class)).collect(Collectors.toSet());
    }

    public Set<CloudFoundryApplication> findApplicationsByKeys(Collection<String> keys, Detail detail) {
        return this.cacheView.getAll(Keys.Namespace.APPLICATIONS.getNs(), keys, (CacheFilter)detail.appFilter()).stream().map(appData -> this.applicationFromCacheData((CacheData)appData, detail)).collect(Collectors.toSet());
    }

    public Optional<CloudFoundryApplication> findApplicationByKey(String key, Detail detail) {
        return Optional.ofNullable(this.cacheView.get(Keys.Namespace.APPLICATIONS.getNs(), key, (CacheFilter)detail.appFilter())).map(appData -> this.applicationFromCacheData((CacheData)appData, detail));
    }

    private CloudFoundryApplication applicationFromCacheData(CacheData appData, Detail detail) {
        CloudFoundryApplication app = (CloudFoundryApplication)this.objectMapper.convertValue(appData.getAttributes().get("resource"), CloudFoundryApplication.class);
        if (detail.equals((Object)Detail.NONE)) {
            return app.withClusters(Collections.emptySet());
        }
        return app.withClusters(this.findClustersByKeys((Collection)appData.getRelationships().get(Keys.Namespace.CLUSTERS.getNs()), Detail.NONE));
    }

    public Set<CloudFoundryCluster> findClustersByKeys(Collection<String> keys, Detail detail) {
        return this.cacheView.getAll(Keys.Namespace.CLUSTERS.getNs(), keys, (CacheFilter)detail.clusterFilter()).stream().map(clusterData -> this.clusterFromCacheData((CacheData)clusterData, detail)).collect(Collectors.toSet());
    }

    public Optional<CloudFoundryCluster> findClusterByKey(String key, Detail detail) {
        return Optional.ofNullable(this.cacheView.get(Keys.Namespace.CLUSTERS.getNs(), key, (CacheFilter)detail.clusterFilter())).map(clusterData -> this.clusterFromCacheData((CacheData)clusterData, detail));
    }

    private CloudFoundryCluster clusterFromCacheData(CacheData clusterData, Detail detail) {
        CloudFoundryCluster cluster = (CloudFoundryCluster)this.objectMapper.convertValue(clusterData.getAttributes().get("resource"), CloudFoundryCluster.class);
        if (detail.equals((Object)Detail.NONE)) {
            return cluster.withServerGroups(Collections.emptySet());
        }
        return cluster.withServerGroups(this.findServerGroupsByKeys((Collection)clusterData.getRelationships().get(Keys.Namespace.SERVER_GROUPS.getNs()), detail.deep()));
    }

    public Set<CloudFoundryServerGroup> findServerGroupsByKeys(Collection<String> keys, Detail detail) {
        return this.cacheView.getAll(Keys.Namespace.SERVER_GROUPS.getNs(), keys, (CacheFilter)detail.serverGroupFilter()).stream().map(serverGroupData -> this.serverGroupFromCacheData((CacheData)serverGroupData, detail)).collect(Collectors.toSet());
    }

    public Optional<CloudFoundryServerGroup> findServerGroupByKey(String key, Detail detail) {
        return Optional.ofNullable(this.cacheView.get(Keys.Namespace.SERVER_GROUPS.getNs(), key, (CacheFilter)detail.serverGroupFilter())).map(serverGroupData -> this.serverGroupFromCacheData((CacheData)serverGroupData, detail));
    }

    private CloudFoundryServerGroup serverGroupFromCacheData(CacheData serverGroupData, Detail detail) {
        CloudFoundryServerGroup serverGroup = (CloudFoundryServerGroup)this.objectMapper.convertValue(serverGroupData.getAttributes().get("resource"), CloudFoundryServerGroup.class);
        if (detail.equals((Object)Detail.NONE)) {
            return serverGroup.withLoadBalancerNames(Collections.emptySet()).withInstances(this.findInstancesByKeys((Collection)serverGroupData.getRelationships().get(Keys.Namespace.INSTANCES.getNs())));
        }
        return serverGroup.withLoadBalancerNames(this.findLoadBalancersByKeys((Collection)serverGroupData.getRelationships().get(Keys.Namespace.LOAD_BALANCERS.getNs()), Detail.NONE).stream().map(CloudFoundryLoadBalancer::getName).collect(Collectors.toSet())).withInstances(this.findInstancesByKeys((Collection)serverGroupData.getRelationships().get(Keys.Namespace.INSTANCES.getNs())));
    }

    public Set<CloudFoundryLoadBalancer> findLoadBalancersByKeys(Collection<String> keys, Detail detail) {
        return this.cacheView.getAll(Keys.Namespace.LOAD_BALANCERS.getNs(), keys, (CacheFilter)detail.loadBalancerFilter()).stream().map(lbData -> this.loadBalancerFromCacheData((CacheData)lbData, detail)).collect(Collectors.toSet());
    }

    private CloudFoundryLoadBalancer loadBalancerFromCacheData(CacheData lbData, Detail detail) {
        CloudFoundryLoadBalancer loadBalancer = (CloudFoundryLoadBalancer)this.objectMapper.convertValue(lbData.getAttributes().get("resource"), CloudFoundryLoadBalancer.class);
        if (detail.equals((Object)Detail.NONE)) {
            return loadBalancer;
        }
        return loadBalancer.withMappedApps(this.findServerGroupsByKeys((Collection)lbData.getRelationships().get(Keys.Namespace.SERVER_GROUPS.getNs()), Detail.NONE));
    }

    public Set<CloudFoundryLoadBalancer> findLoadBalancersByClusterKeys(Collection<String> keys, Detail detail) {
        Set serverGroupKeys = this.cacheView.getAll(Keys.Namespace.CLUSTERS.getNs(), keys).stream().flatMap(cl -> ((Collection)cl.getRelationships().get(Keys.Namespace.SERVER_GROUPS.getNs())).stream()).collect(Collectors.toSet());
        Set loadBalancerKeys = this.cacheView.getAll(Keys.Namespace.SERVER_GROUPS.getNs(), serverGroupKeys).stream().flatMap(sg -> ((Collection)sg.getRelationships().get(Keys.Namespace.LOAD_BALANCERS.getNs())).stream().map(lb -> Keys.getLoadBalancerKey(((CloudFoundryServerGroup)this.objectMapper.convertValue(sg.getAttributes().get("resource"), CloudFoundryServerGroup.class)).getAccount(), lb))).collect(Collectors.toSet());
        return this.findLoadBalancersByKeys(loadBalancerKeys.stream().flatMap(lb -> this.cacheView.filterIdentifiers(Keys.Namespace.LOAD_BALANCERS.getNs(), lb).stream()).collect(Collectors.toSet()), detail);
    }

    public Set<CloudFoundryInstance> findInstancesByKeys(Collection<String> keys) {
        return this.cacheView.getAll(Keys.Namespace.INSTANCES.getNs(), keys).stream().map(instanceData -> (CloudFoundryInstance)this.objectMapper.convertValue(instanceData.getAttributes().get("resource"), CloudFoundryInstance.class)).collect(Collectors.toSet());
    }

    public Optional<CloudFoundryInstance> findInstanceByKey(String key) {
        return Optional.ofNullable(this.cacheView.get(Keys.Namespace.INSTANCES.getNs(), key)).map(instanceData -> (CloudFoundryInstance)this.objectMapper.convertValue(instanceData.getAttributes().get("resource"), CloudFoundryInstance.class));
    }

    public static enum Detail {
        NONE,
        NAMES_ONLY,
        FULL;


        public Detail deep() {
            switch (this) {
                case FULL: {
                    return FULL;
                }
            }
            return NONE;
        }

        public RelationshipCacheFilter appFilter() {
            switch (this) {
                case FULL: 
                case NAMES_ONLY: {
                    return RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.CLUSTERS.getNs()});
                }
            }
            return RelationshipCacheFilter.none();
        }

        public RelationshipCacheFilter clusterFilter() {
            switch (this) {
                case FULL: 
                case NAMES_ONLY: {
                    return RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.SERVER_GROUPS.getNs()});
                }
            }
            return RelationshipCacheFilter.none();
        }

        public RelationshipCacheFilter serverGroupFilter() {
            switch (this) {
                case FULL: 
                case NAMES_ONLY: {
                    return RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.INSTANCES.getNs(), Keys.Namespace.LOAD_BALANCERS.getNs()});
                }
            }
            return RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.INSTANCES.getNs()});
        }

        public RelationshipCacheFilter loadBalancerFilter() {
            switch (this) {
                case FULL: 
                case NAMES_ONLY: {
                    return RelationshipCacheFilter.include((String[])new String[]{Keys.Namespace.SERVER_GROUPS.getNs()});
                }
            }
            return RelationshipCacheFilter.none();
        }
    }
}

