/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.DopplerService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.cloudfoundry.dropsonde.events.EventFactory;
import org.cloudfoundry.dropsonde.events.LogFactory;

public class Logs {
    private final DopplerService api;

    public String recentApplicationLogs(String applicationGuid, int instanceIndex) {
        return this.recentLogsFiltered(applicationGuid, "APP/PROC/WEB", instanceIndex);
    }

    public String recentTaskLogs(String applicationGuid, String taskName) {
        return this.recentLogsFiltered(applicationGuid, "APP/TASK/" + taskName, 0);
    }

    public List<EventFactory.Envelope> recentLogs(String applicationGuid) {
        return (List)CloudFoundryClientUtils.safelyCall(() -> this.api.recentLogs(applicationGuid)).orElseThrow(IllegalStateException::new);
    }

    private String recentLogsFiltered(String applicationGuid, String logSourceFilter, int instanceIndex) {
        List<EventFactory.Envelope> envelopes = this.recentLogs(applicationGuid);
        return envelopes.stream().filter(e -> e.getEventType().equals((Object)EventFactory.Envelope.EventType.LogMessage)).map(EventFactory.Envelope::getLogMessage).filter(logMessage -> logSourceFilter.equals(logMessage.getSourceType()) && logMessage.getSourceInstance().equals(String.valueOf(instanceIndex))).sorted(Comparator.comparingLong(LogFactory.LogMessage::getTimestamp)).map(msg -> msg.getMessage().toStringUtf8()).collect(Collectors.joining("\n"));
    }

    @Generated
    public Logs(DopplerService api) {
        this.api = api;
    }
}

