/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.controller;

import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryCluster;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view.CloudFoundryClusterProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cloudfoundry/images"})
public class CloudFoundryImageController {
    private final CloudFoundryClusterProvider clusterProvider;

    @RequestMapping(value={"/find"}, method={RequestMethod.GET})
    public Collection<CloudFoundryCluster> list(@RequestParam(required=false) String account) {
        Stream<Object> clusters = account == null ? this.clusterProvider.getClusters().values().stream().flatMap(Collection::stream) : this.clusterProvider.getClusters().get(account).stream();
        return clusters.map(cluster -> cluster.withServerGroups(cluster.getServerGroups().stream().filter(serverGroup -> serverGroup.getDroplet() != null).map(serverGroup -> serverGroup.withInstances(Collections.emptySet()).withServiceInstances(Collections.emptyList())).collect(Collectors.toSet()))).filter(cluster -> !cluster.getServerGroups().isEmpty()).collect(Collectors.toSet());
    }

    @Generated
    public CloudFoundryImageController(CloudFoundryClusterProvider clusterProvider) {
        this.clusterProvider = clusterProvider;
    }
}

