/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.RouteId;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.AbstractCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class AbstractCloudFoundryLoadBalancerMappingOperation {
    protected abstract String getPhase();

    protected static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    boolean mapRoutes(AbstractCloudFoundryServerGroupDescription description, @Nullable List<String> routes, CloudFoundrySpace space, String serverGroupId) {
        if (routes == null) {
            AbstractCloudFoundryLoadBalancerMappingOperation.getTask().updateStatus(this.getPhase(), "No load balancers provided to create or update");
            return true;
        }
        AbstractCloudFoundryLoadBalancerMappingOperation.getTask().updateStatus(this.getPhase(), "Creating or updating load balancers");
        CloudFoundryClient client = description.getClient();
        List routeIds = routes.stream().map(routePath -> {
            RouteId routeId = client.getRoutes().toRouteId((String)routePath);
            if (routeId == null) {
                throw new IllegalArgumentException(routePath + " is an invalid route");
            }
            return routeId;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        for (RouteId routeId : routeIds) {
            CloudFoundryLoadBalancer loadBalancer = client.getRoutes().createRoute(routeId, space.getId());
            if (loadBalancer == null) {
                throw new CloudFoundryApiException(new String[]{"Load balancer already exists in another organization and space"});
            }
            AbstractCloudFoundryLoadBalancerMappingOperation.getTask().updateStatus(this.getPhase(), "Mapping load balancer '" + loadBalancer.getName() + "' to " + description.getServerGroupName());
            client.getApplications().mapRoute(serverGroupId, loadBalancer.getId());
        }
        return true;
    }
}

