/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.CloudFoundryRunJobOperationDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class CloudFoundryRunJobOperation
implements AtomicOperation<DeploymentResult> {
    private static final String PHASE = "RUN_CLOUDFOUNDRY_JOB";
    private final CloudFoundryRunJobOperationDescription description;

    public DeploymentResult operate(List priorOutputs) {
        CloudFoundryClient client = this.description.getClient();
        CloudFoundryServerGroup serverGroup = this.description.getServerGroup();
        String applicationGuid = serverGroup.getId();
        String applicationName = serverGroup.getName();
        String originalName = this.description.getJobName();
        String randomString = Long.toHexString(Double.doubleToLongBits(Math.random()));
        String jobName = (String)(StringUtils.isNotEmpty((CharSequence)originalName) ? originalName + "-" : "") + randomString;
        ((Task)TaskRepository.threadLocalTask.get()).updateStatus(PHASE, String.format("Running job '%1$s' as a CloudFoundry task '%1$s' on org/space '%2$s' with application '%3$s'", jobName, this.description.getRegion(), applicationName));
        com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Task cfTask = client.getTasks().createTask(applicationGuid, this.description.getCommand(), jobName);
        DeploymentResult deploymentResult = new DeploymentResult();
        deploymentResult.getDeployedNamesByLocation().put(this.description.getRegion(), Collections.singletonList(cfTask.getGuid()));
        return deploymentResult;
    }

    @Generated
    public CloudFoundryRunJobOperation(CloudFoundryRunJobOperationDescription description) {
        this.description = description;
    }
}

