/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceKeyResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.CreateCloudFoundryServiceKeyDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class CreateCloudFoundryServiceKeyAtomicOperation
implements AtomicOperation<ServiceKeyResponse> {
    private static final String PHASE = "CREATE_SERVICE_KEY";
    private final CreateCloudFoundryServiceKeyDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public ServiceKeyResponse operate(List priorOutputs) {
        Task task = CreateCloudFoundryServiceKeyAtomicOperation.getTask();
        CloudFoundrySpace space = this.description.getSpace();
        String serviceInstanceName = this.description.getServiceInstanceName();
        String serviceKeyName = this.description.getServiceKeyName();
        task.updateStatus(PHASE, "Creating service key '" + serviceKeyName + "' for service '" + serviceInstanceName + "' in '" + space.getRegion() + "'");
        ServiceKeyResponse results = this.description.getClient().getServiceKeys().createServiceKey(space, serviceInstanceName, serviceKeyName);
        task.updateStatus(PHASE, "Finished creating service key '" + serviceKeyName + "'");
        return results;
    }

    @Generated
    public CreateCloudFoundryServiceKeyAtomicOperation(CreateCloudFoundryServiceKeyDescription description) {
        this.description = description;
    }
}

