/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DestroyCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class DestroyCloudFoundryServerGroupAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "DESTROY_SERVER_GROUP";
    private final DestroyCloudFoundryServerGroupDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        DestroyCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Destroying '" + this.description.getServerGroupName() + "'");
        CloudFoundryClient client = this.description.getClient();
        client.getApplications().deleteApplication(this.description.getServerGroupId());
        DestroyCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Destroyed '" + this.description.getServerGroupName() + "'");
        return null;
    }

    @Generated
    public DestroyCloudFoundryServerGroupAtomicOperation(DestroyCloudFoundryServerGroupDescription description) {
        this.description = description;
    }
}

