/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.validators;

import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import java.util.List;
import java.util.stream.Collectors;

public class StandardCloudFoundryAttributeValidator {
    private String context;
    private ValidationErrors errors;

    public StandardCloudFoundryAttributeValidator(String context, ValidationErrors errors) {
        this.context = context;
        this.errors = errors;
    }

    public void validateRegions(String region, CloudFoundryCredentials credentials) {
        List filteredRegions = credentials.getFilteredSpaces().stream().map(s -> s.getRegion()).collect(Collectors.toList());
        if (!credentials.getFilteredSpaces().isEmpty() && !filteredRegions.contains(region)) {
            this.errors.rejectValue(this.context + ".region", this.context + ".region.notValid");
        }
    }
}

