/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryCluster;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import com.netflix.spinnaker.clouddriver.model.Application;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonDeserialize(builder=CloudFoundryApplicationBuilder.class)
@JsonIgnoreProperties(value={"clusters"})
public final class CloudFoundryApplication
implements Application {
    @JsonView(value={Views.Cache.class})
    private final String name;
    @JsonView(value={Views.Relationship.class})
    private final Set<CloudFoundryCluster> clusters;

    public Map<String, Set<String>> getClusterNames() {
        return this.clusters == null ? Collections.emptyMap() : this.clusters.stream().collect(Collectors.groupingBy(CloudFoundryCluster::getAccountName, Collectors.mapping(CloudFoundryCluster::getName, Collectors.toSet())));
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    @Generated
    CloudFoundryApplication(String name, Set<CloudFoundryCluster> clusters) {
        this.name = name;
        this.clusters = clusters;
    }

    @Generated
    public static CloudFoundryApplicationBuilder builder() {
        return new CloudFoundryApplicationBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Set<CloudFoundryCluster> getClusters() {
        return this.clusters;
    }

    @Generated
    public String toString() {
        return "CloudFoundryApplication(name=" + this.getName() + ", clusters=" + this.getClusters() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryApplication)) {
            return false;
        }
        CloudFoundryApplication other = (CloudFoundryApplication)o;
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public CloudFoundryApplication withClusters(Set<CloudFoundryCluster> clusters) {
        return this.clusters == clusters ? this : new CloudFoundryApplication(this.name, clusters);
    }

    @Generated
    public static class CloudFoundryApplicationBuilder {
        @Generated
        private String name;
        @Generated
        private Set<CloudFoundryCluster> clusters;

        @Generated
        CloudFoundryApplicationBuilder() {
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryApplicationBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonView(value={Views.Relationship.class})
        @Generated
        public CloudFoundryApplicationBuilder clusters(Set<CloudFoundryCluster> clusters) {
            this.clusters = clusters;
            return this;
        }

        @Generated
        public CloudFoundryApplication build() {
            return new CloudFoundryApplication(this.name, this.clusters);
        }

        @Generated
        public String toString() {
            return "CloudFoundryApplication.CloudFoundryApplicationBuilder(name=" + this.name + ", clusters=" + this.clusters + ")";
        }
    }
}

