/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.ResourceCacheData;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.RouteId;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent.AbstractCloudFoundryCachingAgent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.core.provider.agent.Namespace;
import io.vavr.collection.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudFoundryLoadBalancerCachingAgent
extends AbstractCloudFoundryCachingAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudFoundryLoadBalancerCachingAgent.class);
    private static final ObjectMapper cacheViewMapper = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    private final Collection<AgentDataType> providedDataTypes = Collections.singletonList(AgentDataType.Authority.AUTHORITATIVE.forType(Namespace.LOAD_BALANCERS.getNs()));

    public CloudFoundryLoadBalancerCachingAgent(CloudFoundryCredentials credentials, Registry registry) {
        super(credentials, registry);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        long loadDataStart = this.getInternalClock().millis();
        String accountName = this.getAccountName();
        log.info("Caching all load balancers (routes) in Cloud Foundry account " + accountName);
        List<CloudFoundrySpace> spaceFilters = this.getCredentials().getFilteredSpaces();
        List<CloudFoundryLoadBalancer> loadBalancers = this.getClient().getRoutes().all(spaceFilters);
        Collection onDemandCacheData = providerCache.getAll(Namespace.ON_DEMAND.getNs(), providerCache.filterIdentifiers(Namespace.ON_DEMAND.getNs(), Keys.getAllLoadBalancers()));
        ArrayList toEvict = new ArrayList();
        java.util.HashMap toKeep = new java.util.HashMap();
        onDemandCacheData.forEach(cacheData -> {
            long cacheTime = (Long)cacheData.getAttributes().get("cacheTime");
            if (cacheTime < loadDataStart && (Integer)cacheData.getAttributes().computeIfAbsent("processedCount", s -> 0) > 0) {
                toEvict.add(cacheData.getId());
            } else {
                toKeep.put(cacheData.getId(), cacheData);
            }
        });
        java.util.HashMap loadBalancersByServerGroupIds = new java.util.HashMap();
        loadBalancers.stream().forEach(lb -> lb.getMappedApps().stream().forEach(sg -> loadBalancersByServerGroupIds.computeIfAbsent(sg.getId(), s -> new ResourceCacheData(Keys.getServerGroupKey(sg.getAccount(), sg.getName(), sg.getRegion()), Collections.emptyMap(), new java.util.HashMap<String, Collection<String>>())).getRelationships().computeIfAbsent(Namespace.LOAD_BALANCERS.getNs(), k -> new HashSet()).add(lb.getId())));
        java.util.HashMap results = HashMap.of((Object)Namespace.LOAD_BALANCERS.getNs(), (Object)loadBalancers.stream().map(lb -> this.setCacheData(toKeep, (CloudFoundryLoadBalancer)lb, loadDataStart)).collect(Collectors.toSet()), (Object)Namespace.SERVER_GROUPS.getNs(), loadBalancersByServerGroupIds.values()).toJavaMap();
        onDemandCacheData.forEach(this::processOnDemandCacheData);
        results.put(Namespace.ON_DEMAND.getNs(), toKeep.values());
        log.debug("LoadBalancer cache loaded for Cloud Foundry account {}, ({} sec)", (Object)accountName, (Object)((this.getInternalClock().millis() - loadDataStart) / 1000L));
        return new DefaultCacheResult((Map)results, Collections.singletonMap(Namespace.ON_DEMAND.getNs(), toEvict));
    }

    private CacheData setCacheData(Map<String, CacheData> onDemandCacheDataToKeep, CloudFoundryLoadBalancer cloudFoundryLoadBalancer, long start) {
        String account = this.getAccountName();
        String key = Keys.getLoadBalancerKey(account, cloudFoundryLoadBalancer);
        CacheData lbCacheData = onDemandCacheDataToKeep.get(key);
        if (lbCacheData != null && (Long)lbCacheData.getAttributes().get("cacheTime") > start) {
            Map<String, Collection<ResourceCacheData>> cacheResults = this.getCacheResultsFromCacheData(lbCacheData);
            onDemandCacheDataToKeep.remove(key);
            return cacheResults.get(Namespace.LOAD_BALANCERS.getNs()).stream().findFirst().orElse(null);
        }
        return new ResourceCacheData(Keys.getLoadBalancerKey(account, cloudFoundryLoadBalancer), CloudFoundryLoadBalancerCachingAgent.cacheView(cloudFoundryLoadBalancer), Collections.singletonMap(Namespace.SERVER_GROUPS.getNs(), (Collection)cloudFoundryLoadBalancer.getServerGroups().stream().map(sg -> Keys.getServerGroupKey(account, sg.getName(), sg.getRegion())).collect(Collectors.toSet())));
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return type.equals((Object)OnDemandType.LoadBalancer) && cloudProvider.equals("cloudfoundry");
    }

    @Nullable
    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        Map<String, Collection<Object>> evictions;
        DefaultCacheResult loadBalancerCacheResults;
        String account = Optional.ofNullable(data.get("account")).map(Object::toString).orElse(null);
        String region = Optional.ofNullable(data.get("region")).map(Object::toString).orElse(null);
        String loadBalancerName = Optional.ofNullable(data.get("loadBalancerName")).map(Object::toString).orElse(null);
        if (account == null || region == null || loadBalancerName == null) {
            return null;
        }
        if (!this.getAccountName().equals(account)) {
            return null;
        }
        CloudFoundrySpace space = this.getClient().getSpaces().findSpaceByRegion(region).orElse(null);
        if (space == null) {
            return null;
        }
        log.info("On Demand cache refresh triggered, waiting for load balancers loadData to be called");
        RouteId routeId = this.getClient().getRoutes().toRouteId(loadBalancerName);
        if (routeId == null) {
            return null;
        }
        CloudFoundryLoadBalancer cloudFoundryLoadBalancer = this.getClient().getRoutes().find(routeId, space.getId());
        String loadBalancerKey = Optional.ofNullable(cloudFoundryLoadBalancer).map(lb -> Keys.getLoadBalancerKey(account, lb)).orElse(Keys.getLoadBalancerKey(this.getAccountName(), loadBalancerName, region));
        if (cloudFoundryLoadBalancer != null) {
            Set<ResourceCacheData> loadBalancerCacheData = Collections.singleton(new ResourceCacheData(loadBalancerKey, CloudFoundryLoadBalancerCachingAgent.cacheView(cloudFoundryLoadBalancer), Collections.singletonMap(Namespace.SERVER_GROUPS.getNs(), (Collection)cloudFoundryLoadBalancer.getServerGroups().stream().map(sg -> Keys.getServerGroupKey(account, sg.getName(), sg.getRegion())).collect(Collectors.toSet()))));
            loadBalancerCacheResults = new DefaultCacheResult(Collections.singletonMap(Namespace.LOAD_BALANCERS.getNs(), loadBalancerCacheData));
            providerCache.putCacheData(Namespace.ON_DEMAND.getNs(), this.buildOnDemandCacheData(loadBalancerKey, loadBalancerCacheResults.getCacheResults()));
            evictions = Collections.emptyMap();
        } else {
            loadBalancerCacheResults = new DefaultCacheResult(Collections.singletonMap(Namespace.LOAD_BALANCERS.getNs(), Collections.emptyList()));
            evictions = Collections.singletonMap(Namespace.LOAD_BALANCERS.getNs(), providerCache.filterIdentifiers(Namespace.LOAD_BALANCERS.getNs(), loadBalancerKey));
        }
        return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), (CacheResult)loadBalancerCacheResults, evictions);
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        Collection keys = providerCache.filterIdentifiers(Namespace.ON_DEMAND.getNs(), Keys.getAllLoadBalancers());
        return providerCache.getAll(Namespace.ON_DEMAND.getNs(), keys, (CacheFilter)RelationshipCacheFilter.none()).stream().map(it -> {
            String loadbalancerId = it.getId();
            Map details = Keys.parse(loadbalancerId).orElse(Collections.emptyMap());
            Map attributes = it.getAttributes();
            return HashMap.of((Object)"id", (Object)loadbalancerId, (Object)"details", details, (Object)"moniker", (Object)this.convertOnDemandDetails(details), (Object)"cacheTime", attributes.get("cacheTime"), (Object)"cacheExpiry", attributes.get("cacheExpiry"), (Object)"processedCount", attributes.get("processedCount"), (Object)"processedTime", attributes.get("processedTime")).toJavaMap();
        }).collect(Collectors.toSet());
    }

    @Generated
    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

