/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.ResourceCacheData;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent.AbstractCloudFoundryCachingAgent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudFoundrySpaceCachingAgent
extends AbstractCloudFoundryCachingAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudFoundrySpaceCachingAgent.class);
    private static final ObjectMapper cacheViewMapper = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    private final Collection<AgentDataType> providedDataTypes = Arrays.asList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.SPACES.getNs()));

    public CloudFoundrySpaceCachingAgent(CloudFoundryCredentials credentials, Registry registry) {
        super(credentials, registry);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        long loadDataStart = this.getInternalClock().millis();
        String accountName = this.getAccountName();
        log.info("Caching all spaces in Cloud Foundry account " + accountName);
        List<CloudFoundrySpace> spaces = this.getClient().getSpaces().all();
        if (!this.getCredentials().getFilteredSpaces().isEmpty()) {
            List filteredRegions = this.getCredentials().getFilteredSpaces().stream().map(s -> s.getRegion()).collect(Collectors.toList());
            spaces = spaces.stream().filter(s -> filteredRegions.contains(s.getRegion())).collect(Collectors.toList());
        }
        ImmutableMap results = ImmutableMap.of((Object)Keys.Namespace.SPACES.getNs(), (Object)spaces.stream().map(s -> new ResourceCacheData(Keys.getSpaceKey(accountName, s.getRegion()), CloudFoundrySpaceCachingAgent.cacheView(s), Collections.emptyMap())).collect(Collectors.toSet()));
        log.debug("Space cache loaded for Cloud Foundry account {}, ({} sec)", (Object)accountName, (Object)((this.getInternalClock().millis() - loadDataStart) / 1000L));
        return new DefaultCacheResult((Map)results, Collections.emptyMap());
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return false;
    }

    @Nullable
    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        return null;
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        return null;
    }

    @Generated
    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

