/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.CacheRepository;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Logs;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Task;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.model.InstanceProvider;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryInstanceProvider
implements InstanceProvider<CloudFoundryInstance, String> {
    private final CacheRepository repository;
    private final CredentialsRepository<CloudFoundryCredentials> credentialsRepository;

    @Nullable
    public CloudFoundryInstance getInstance(String account, String region, String id) {
        return this.repository.findInstanceByKey(Keys.getInstanceKey(account, id)).orElse(null);
    }

    public String getConsoleOutput(String account, String region, String id) {
        String logs;
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.credentialsRepository.getOne(account);
        if (credentials == null) {
            return null;
        }
        CloudFoundryClient client = credentials.getClient();
        Logs logsService = client.getLogs();
        CloudFoundryConsoleOutputIdParameter idParam = CloudFoundryConsoleOutputIdParameter.fromString(id);
        LogsResourceType logsResourceType = idParam.logsResourceType;
        switch (logsResourceType) {
            case APP: {
                logs = logsService.recentApplicationLogs(idParam.guid, idParam.instanceIndex);
                break;
            }
            case TASK: {
                Task task = client.getTasks().getTask(idParam.guid);
                String appGuid = task.getLinks().get("app").getGuid();
                logs = logsService.recentTaskLogs(appGuid, task.getName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported LogsResourceType: " + logsResourceType);
            }
        }
        return logs;
    }

    public final String getCloudProvider() {
        return CloudFoundryCloudProvider.ID;
    }

    @Generated
    public CloudFoundryInstanceProvider(CacheRepository repository, CredentialsRepository<CloudFoundryCredentials> credentialsRepository) {
        this.repository = repository;
        this.credentialsRepository = credentialsRepository;
    }

    static enum LogsResourceType {
        APP,
        TASK;

    }

    static class CloudFoundryConsoleOutputIdParameter {
        private final LogsResourceType logsResourceType;
        private final String guid;
        private final int instanceIndex;

        static CloudFoundryConsoleOutputIdParameter fromString(String value) {
            try {
                String[] parts = value.split(":");
                LogsResourceType type = LogsResourceType.valueOf(parts[0].toUpperCase());
                return new CloudFoundryConsoleOutputIdParameter(type, parts[1], type == LogsResourceType.APP ? Integer.parseInt(parts[2]) : 0);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Error parsing '%s'. Expected format: 'app:appGuid:instanceIndex' or 'task:taskGuid'", value), e);
            }
        }

        @Generated
        public CloudFoundryConsoleOutputIdParameter(LogsResourceType logsResourceType, String guid, int instanceIndex) {
            this.logsResourceType = logsResourceType;
            this.guid = guid;
            this.instanceIndex = instanceIndex;
        }

        @Generated
        public LogsResourceType getLogsResourceType() {
            return this.logsResourceType;
        }

        @Generated
        public String getGuid() {
            return this.guid;
        }

        @Generated
        public int getInstanceIndex() {
            return this.instanceIndex;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloudFoundryConsoleOutputIdParameter)) {
                return false;
            }
            CloudFoundryConsoleOutputIdParameter other = (CloudFoundryConsoleOutputIdParameter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getInstanceIndex() != other.getInstanceIndex()) {
                return false;
            }
            LogsResourceType this$logsResourceType = this.getLogsResourceType();
            LogsResourceType other$logsResourceType = other.getLogsResourceType();
            if (this$logsResourceType == null ? other$logsResourceType != null : !((Object)((Object)this$logsResourceType)).equals((Object)other$logsResourceType)) {
                return false;
            }
            String this$guid = this.getGuid();
            String other$guid = other.getGuid();
            return !(this$guid == null ? other$guid != null : !this$guid.equals(other$guid));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CloudFoundryConsoleOutputIdParameter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getInstanceIndex();
            LogsResourceType $logsResourceType = this.getLogsResourceType();
            result = result * 59 + ($logsResourceType == null ? 43 : ((Object)((Object)$logsResourceType)).hashCode());
            String $guid = this.getGuid();
            result = result * 59 + ($guid == null ? 43 : $guid.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CloudFoundryInstanceProvider.CloudFoundryConsoleOutputIdParameter(logsResourceType=" + this.getLogsResourceType() + ", guid=" + this.getGuid() + ", instanceIndex=" + this.getInstanceIndex() + ")";
        }
    }
}

