/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Spaces;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ServiceKeyService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceKeyResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceKey;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.LastOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceCredentials;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceKey;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class ServiceKeys {
    private final ServiceKeyService api;
    private final Spaces spaces;

    public ServiceKeyResponse createServiceKey(CloudFoundrySpace space, String serviceInstanceName, String serviceKeyName) {
        return Optional.ofNullable(this.spaces.getServiceInstanceByNameAndSpace(serviceInstanceName, space)).map(ssi -> this.getServiceKey(ssi.getId(), serviceKeyName).map(Resource::getEntity).map(ServiceKey::getCredentials).orElseGet(() -> CloudFoundryClientUtils.safelyCall(() -> this.api.createServiceKey(new CreateServiceKey().setName(serviceKeyName).setServiceInstanceGuid(ssi.getId()))).map(Resource::getEntity).map(ServiceCredentials::getCredentials).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Service key '" + serviceKeyName + "' could not be created for service instance '" + serviceInstanceName + "' in region '" + space.getRegion() + "'"})))).map(serviceCredentials -> (ServiceKeyResponse)new ServiceKeyResponse().setServiceKeyName(serviceKeyName).setServiceKey((Map<String, Object>)serviceCredentials).setType(LastOperation.Type.CREATE_SERVICE_KEY).setState(LastOperation.State.SUCCEEDED).setServiceInstanceName(serviceInstanceName)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Service instance '" + serviceInstanceName + "' not found in region '" + space.getRegion() + "'"}));
    }

    public ServiceKeyResponse deleteServiceKey(CloudFoundrySpace space, String serviceInstanceName, String serviceKeyName) {
        return Optional.ofNullable(this.spaces.getServiceInstanceByNameAndSpace(serviceInstanceName, space)).map(ssi -> this.getServiceKey(ssi.getId(), serviceKeyName).map(serviceKeyResource -> CloudFoundryClientUtils.safelyCall(() -> this.api.deleteServiceKey(serviceKeyResource.getMetadata().getGuid())))).map(_a -> (ServiceKeyResponse)new ServiceKeyResponse().setServiceKeyName(serviceKeyName).setType(LastOperation.Type.CREATE_SERVICE_KEY).setState(LastOperation.State.SUCCEEDED).setServiceInstanceName(serviceInstanceName)).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cannot find service '" + serviceInstanceName + "' in region '" + space.getRegion() + "'"}));
    }

    Optional<Resource<ServiceKey>> getServiceKey(String serviceInstanceId, String serviceKeyName) {
        List<String> queryParams = Arrays.asList("service_instance_guid:" + serviceInstanceId, "name:" + serviceKeyName);
        return CloudFoundryClientUtils.collectPageResources("service key by service instance id and service key name", pg -> this.api.getServiceKey((Integer)pg, queryParams)).stream().findFirst();
    }

    @Generated
    public ServiceKeys(ServiceKeyService api, Spaces spaces) {
        this.api = api;
        this.spaces = spaces;
    }
}

