/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.api;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Application;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ApplicationEnv;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.InstanceStatus;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.MapRoute;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Page;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Build;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateBuild;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreatePackage;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Droplet;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Package;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Pagination;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.StartApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.StopApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ToOneRelationship;
import java.util.List;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface ApplicationService {
    @GET(value="/v3/apps")
    public Call<Pagination<com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application>> all(@Query(value="page") Integer var1, @Query(value="per_page") Integer var2, @Query(value="names") List<String> var3, @Query(value="space_guids") String var4);

    @GET(value="/v3/apps/{guid}")
    public Call<com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application> findById(@Path(value="guid") String var1);

    @GET(value="/v2/apps/{guid}/env")
    public Call<ApplicationEnv> findApplicationEnvById(@Path(value="guid") String var1);

    @GET(value="/v3/apps/{guid}/droplets/current")
    public Call<Droplet> findDropletByApplicationGuid(@Path(value="guid") String var1);

    @GET(value="/v2/apps/{guid}/instances")
    public Call<Map<String, InstanceStatus>> instances(@Path(value="guid") String var1);

    @GET(value="/v2/apps")
    public Call<Page<Application>> listAppsFiltered(@Query(value="page") Integer var1, @Query(value="q") List<String> var2, @Query(value="results-per-page") Integer var3);

    @PUT(value="/v2/apps/{aguid}/routes/{rguid}")
    public Call<ResponseBody> mapRoute(@Path(value="aguid") String var1, @Path(value="rguid") String var2, @Body MapRoute var3);

    @DELETE(value="/v2/apps/{aguid}/routes/{rguid}")
    public Call<ResponseBody> unmapRoute(@Path(value="aguid") String var1, @Path(value="rguid") String var2);

    @POST(value="/v3/apps/{guid}/actions/start")
    public Call<ResponseBody> startApplication(@Path(value="guid") String var1, @Body StartApplication var2);

    @POST(value="/v3/apps/{guid}/actions/stop")
    public Call<ResponseBody> stopApplication(@Path(value="guid") String var1, @Body StopApplication var2);

    @DELETE(value="/v3/apps/{guid}")
    public Call<ResponseBody> deleteApplication(@Path(value="guid") String var1);

    @DELETE(value="/v2/apps/{guid}/instances/{index}")
    public Call<ResponseBody> deleteAppInstance(@Path(value="guid") String var1, @Path(value="index") String var2);

    @POST(value="/v3/apps")
    public Call<com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application> createApplication(@Body CreateApplication var1);

    @GET(value="/v3/apps/{guid}/packages")
    public Call<Pagination<Package>> findPackagesByAppId(@Path(value="guid") String var1);

    @POST(value="/v3/packages")
    public Call<Package> createPackage(@Body CreatePackage var1);

    @GET(value="/v3/packages/{guid}")
    public Call<Package> getPackage(@Path(value="guid") String var1);

    @GET(value="/v3/packages/{guid}/download")
    public Call<ResponseBody> downloadPackage(@Path(value="guid") String var1);

    @Multipart
    @POST(value="/v3/packages/{guid}/upload")
    public Call<Package> uploadPackageBits(@Path(value="guid") String var1, @Part MultipartBody.Part var2);

    @POST(value="/v3/builds")
    public Call<Build> createBuild(@Body CreateBuild var1);

    @GET(value="/v3/builds/{guid}")
    public Call<Build> getBuild(@Path(value="guid") String var1);

    @PATCH(value="/v3/apps/{guid}/relationships/current_droplet")
    public Call<ResponseBody> setCurrentDroplet(@Path(value="guid") String var1, @Body ToOneRelationship var2);

    @POST(value="/v2/apps/{guid}/restage")
    public Call<ResponseBody> restageApplication(@Path(value="guid") String var1, @Body Object var2);

    @GET(value="/v2/apps/{guid}/service_bindings")
    public Call<Page<ServiceBinding>> getServiceBindings(@Path(value="guid") String var1);
}

