/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Task;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryJobStatus;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.model.JobProvider;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import java.util.Map;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryJobProvider
implements JobProvider<CloudFoundryJobStatus> {
    private String platform = CloudFoundryCloudProvider.ID;
    private final CredentialsRepository<CloudFoundryCredentials> credentialsRepository;

    public CloudFoundryJobProvider(CredentialsRepository<CloudFoundryCredentials> credentialsRepository) {
        this.credentialsRepository = credentialsRepository;
    }

    public CloudFoundryJobStatus collectJob(String account, String location, String id) {
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.credentialsRepository.getOne(account);
        if (credentials == null) {
            return null;
        }
        Task task = credentials.getClient().getTasks().getTask(id);
        return CloudFoundryJobStatus.fromTask(task, account, location);
    }

    public Map<String, Object> getFileContents(String account, String location, String id, String fileName) {
        return null;
    }

    public void cancelJob(String account, String location, String taskGuid) {
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.credentialsRepository.getOne(account);
        if (credentials == null) {
            return;
        }
        credentials.getClient().getTasks().cancelTask(taskGuid);
    }

    @Generated
    public String getPlatform() {
        return this.platform;
    }
}

