/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.ScaleCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CloudFoundryOperationUtils;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.model.ServerGroup;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class ScaleCloudFoundryServerGroupAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "RESIZE_SERVER_GROUP";
    private final OperationPoller operationPoller;
    private final ScaleCloudFoundryServerGroupDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        ScaleCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Resizing '" + this.description.getServerGroupName() + "'");
        CloudFoundryClient client = this.description.getClient();
        ServerGroup.Capacity capacity = this.description.getCapacity();
        boolean scaleStoppedInstance = Optional.ofNullable(this.description.getScaleStoppedServerGroup()).orElse(false);
        Integer numInstances = Optional.ofNullable(capacity).map(c -> scaleStoppedInstance ? capacity.getMax() : capacity.getDesired()).orElse(null);
        client.getProcesses().scaleProcess(this.description.getServerGroupId(), numInstances, this.description.getMemory(), this.description.getDiskQuota());
        ProcessStats.State state = (ProcessStats.State)((Object)this.operationPoller.waitForOperation(() -> client.getApplications().getAppState(this.description.getServerGroupId()), inProgressState -> inProgressState == ProcessStats.State.RUNNING || inProgressState == ProcessStats.State.CRASHED || inProgressState == ProcessStats.State.DOWN, null, ScaleCloudFoundryServerGroupAtomicOperation.getTask(), this.description.getServerGroupName(), PHASE));
        if (!(state == ProcessStats.State.RUNNING || state == ProcessStats.State.DOWN && this.description.getCapacity().getDesired() == 0 || state == ProcessStats.State.DOWN && Boolean.TRUE.equals(this.description.getScaleStoppedServerGroup()))) {
            throw new CloudFoundryApiException(new String[]{"Failed to start '" + this.description.getServerGroupName() + "' which instead " + CloudFoundryOperationUtils.describeProcessState(state)});
        }
        ScaleCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Resized '" + this.description.getServerGroupName() + "'");
        return null;
    }

    @Generated
    public ScaleCloudFoundryServerGroupAtomicOperation(OperationPoller operationPoller, ScaleCloudFoundryServerGroupDescription description) {
        this.operationPoller = operationPoller;
        this.description = description;
    }
}

