/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.frigga.Names;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Processes;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Spaces;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.ApplicationService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ErrorDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Application;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ApplicationEnv;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.InstanceStatus;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.MapRoute;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Build;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreateBuild;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreatePackage;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Droplet;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Lifecycle;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Package;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Process;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Relationship;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.StartApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.StopApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ToOneRelationship;
import com.netflix.spinnaker.clouddriver.cloudfoundry.config.CloudFoundryConfigurationProperties;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.ArtifactInfo;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryBuildInfo;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryBuildpack;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryCluster;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryDroplet;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryPackage;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.ServerGroupMetaDataEnvVar;
import com.netflix.spinnaker.clouddriver.helpers.AbstractServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.model.HealthState;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Applications {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Applications.class);
    private final String account;
    private final String appsManagerUri;
    private final String metricsUri;
    private final ApplicationService api;
    private final Spaces spaces;
    private final Processes processes;
    private final Integer resultsPerPage;
    private final boolean onlySpinnakerManaged;
    private final ForkJoinPool forkJoinPool;
    private final LoadingCache<String, CloudFoundryServerGroup> serverGroupCache;

    public Applications(String account, String appsManagerUri, String metricsUri, final ApplicationService api, Spaces spaces, Processes processes, Integer resultsPerPage, boolean onlySpinnakerManaged, ForkJoinPool forkJoinPool, CloudFoundryConfigurationProperties.LocalCacheConfig localCacheConfig) {
        this.account = account;
        this.appsManagerUri = appsManagerUri;
        this.metricsUri = metricsUri;
        this.api = api;
        this.spaces = spaces;
        this.processes = processes;
        this.resultsPerPage = resultsPerPage;
        this.onlySpinnakerManaged = onlySpinnakerManaged;
        this.forkJoinPool = forkJoinPool;
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (localCacheConfig.getApplicationsAccessExpirySeconds() >= 0L) {
            builder.expireAfterAccess(localCacheConfig.getApplicationsAccessExpirySeconds(), TimeUnit.SECONDS);
        }
        if (localCacheConfig.getApplicationsWriteExpirySeconds() >= 0L) {
            builder.expireAfterWrite(localCacheConfig.getApplicationsWriteExpirySeconds(), TimeUnit.SECONDS);
        }
        this.serverGroupCache = builder.build((CacheLoader)new CacheLoader<String, CloudFoundryServerGroup>(){

            public CloudFoundryServerGroup load(@Nonnull String guid) throws ResourceNotFoundException {
                return (CloudFoundryServerGroup)CloudFoundryClientUtils.safelyCall(() -> api.findById(guid)).map(Applications.this::map).flatMap(sg -> sg).orElseThrow(ResourceNotFoundException::new);
            }
        });
    }

    @Nullable
    public CloudFoundryServerGroup findById(String guid) {
        try {
            return (CloudFoundryServerGroup)this.serverGroupCache.get((Object)guid);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ResourceNotFoundException) {
                return null;
            }
            throw new CloudFoundryApiException(e.getCause(), "Unable to find server group by id");
        }
    }

    public List<CloudFoundryApplication> all(List<String> spaceGuids) {
        log.debug("Listing all applications from account {}", (Object)this.account);
        String spaceGuidsQ = spaceGuids == null || spaceGuids.isEmpty() ? null : String.join((CharSequence)",", spaceGuids);
        List newCloudFoundryAppList = CloudFoundryClientUtils.collectPages("applications", page -> this.api.all((Integer)page, this.resultsPerPage, null, spaceGuidsQ));
        log.debug("Fetched {} total apps from foundation account {}", (Object)newCloudFoundryAppList.size(), (Object)this.account);
        List cacheableApplications = newCloudFoundryAppList.stream().filter(this::shouldCacheApplication).collect(Collectors.toUnmodifiableList());
        List availableAppIds = cacheableApplications.stream().map(com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application::getGuid).collect(Collectors.toList());
        long invalidatedServerGroups = this.serverGroupCache.asMap().keySet().parallelStream().filter(appGuid -> !availableAppIds.contains(appGuid)).peek(appGuid -> log.trace("Evicting the following SG with id '{}'", appGuid)).peek(arg_0 -> this.serverGroupCache.invalidate(arg_0)).count();
        log.debug("Evicted {} serverGroups from the cache that aren't on the '{}' foundation anymore", (Object)invalidatedServerGroups, (Object)this.account);
        try {
            ((ForkJoinTask)this.forkJoinPool.submit(() -> cacheableApplications.parallelStream().filter(app -> {
                CloudFoundryServerGroup cachedApp = this.findById(app.getGuid());
                if (cachedApp != null) {
                    if (!cachedApp.getUpdatedTime().equals(app.getUpdatedAt().toInstant().toEpochMilli())) {
                        log.trace("App '{}' cached version is out of date on foundation '{}'", (Object)app.getName(), (Object)this.account);
                        return true;
                    }
                    return false;
                }
                log.trace("App '{}' not found in cache for foundation '{}'", (Object)app.getName(), (Object)this.account);
                return true;
            }).map(this::map).filter(Optional::isPresent).map(Optional::get).forEach(sg -> this.serverGroupCache.put((Object)sg.getId(), sg)))).get();
            ((ForkJoinTask)this.forkJoinPool.submit(() -> cacheableApplications.parallelStream().forEach(a -> this.serverGroupCache.put((Object)a.getGuid(), (Object)this.checkHealthStatus(this.findById(a.getGuid()), (com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application)a))))).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, Set> serverGroupsByClusters = new HashMap<String, Set>();
        HashMap<String, Set> clustersByApps = new HashMap<String, Set>();
        for (CloudFoundryServerGroup serverGroup : this.serverGroupCache.asMap().values()) {
            Names names = Names.parseName((String)serverGroup.getName());
            serverGroupsByClusters.computeIfAbsent(names.getCluster(), clusterName -> new HashSet()).add(serverGroup);
            clustersByApps.computeIfAbsent(names.getApp(), appName -> new HashSet()).add(names.getCluster());
        }
        return clustersByApps.entrySet().stream().map((? super T clustersByApp) -> CloudFoundryApplication.builder().name((String)clustersByApp.getKey()).clusters(((Set)clustersByApp.getValue()).stream().map((? super T clusterName) -> CloudFoundryCluster.builder().accountName(this.account).name((String)clusterName).serverGroups((Set)serverGroupsByClusters.get(clusterName)).build()).collect(Collectors.toSet())).build()).collect(Collectors.toList());
    }

    @Nullable
    public CloudFoundryServerGroup findServerGroupByNameAndSpaceId(String name, String spaceId) {
        Optional result = CloudFoundryClientUtils.safelyCall(() -> this.api.all(null, 1, Collections.singletonList(name), spaceId)).flatMap(page -> page.getResources().stream().findFirst().map(this::map).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Not authorized error retrieving details for this Server Group"})));
        result.ifPresent(sg -> this.serverGroupCache.put((Object)sg.getId(), sg));
        return result.orElse(null);
    }

    @Nullable
    public String findServerGroupId(String name, String spaceId) {
        return this.serverGroupCache.asMap().values().stream().filter(serverGroup -> serverGroup.getName().equalsIgnoreCase(name) && serverGroup.getSpace().getId().equals(spaceId)).findFirst().map(CloudFoundryServerGroup::getId).orElseGet(() -> CloudFoundryClientUtils.safelyCall(() -> this.api.all(null, 1, Collections.singletonList(name), spaceId)).flatMap(page -> page.getResources().stream().findFirst().map(this::map).filter(Optional::isPresent).map(Optional::get).map((? super T serverGroup) -> {
            this.serverGroupCache.put((Object)serverGroup.getId(), serverGroup);
            return serverGroup;
        }).map(CloudFoundryServerGroup::getId)).orElse(null));
    }

    private boolean shouldCacheApplication(com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application application) {
        Names names = Names.parseName((String)application.getName());
        if (names.getCluster() == null) {
            log.debug("Skipping app '{}' from foundation '{}' because the name isn't following the frigga naming schema.", (Object)application.getName(), (Object)this.account);
            return false;
        }
        if (this.onlySpinnakerManaged && names.getSequence() == null) {
            log.debug("Skipping app '{}' from foundation '{}' because onlySpinnakerManaged is true and it has no version.", (Object)application.getName(), (Object)this.account);
            return false;
        }
        return true;
    }

    private Optional<CloudFoundryServerGroup> map(com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application application) {
        ApplicationEnv applicationEnv;
        CloudFoundryServerGroup.State state = CloudFoundryServerGroup.State.valueOf(application.getState());
        CloudFoundrySpace space = this.spaces.findById(application.getLinks().get("space").getGuid());
        String appId = application.getGuid();
        try {
            applicationEnv = CloudFoundryClientUtils.safelyCall(() -> this.api.findApplicationEnvById(appId)).orElse(null);
        }
        catch (CloudFoundryApiException e2) {
            if (e2.getErrorCode() == ErrorDescription.Code.NOT_AUTHORIZED) {
                return Optional.empty();
            }
            applicationEnv = null;
        }
        Process process = this.processes.findProcessById(appId).orElse(null);
        CloudFoundryDroplet droplet = null;
        try {
            CloudFoundryPackage cfPackage = CloudFoundryClientUtils.safelyCall(() -> this.api.findPackagesByAppId(appId)).flatMap(packages -> packages.getResources().stream().findFirst().map((? super T pkg) -> CloudFoundryPackage.builder().downloadUrl(pkg.getLinks().containsKey("download") ? pkg.getLinks().get("download").getHref() : null).checksumType(pkg.getData().getChecksum() == null ? null : pkg.getData().getChecksum().getType()).checksum(pkg.getData().getChecksum() == null ? null : pkg.getData().getChecksum().getValue()).build())).orElse(null);
            droplet = CloudFoundryClientUtils.safelyCall(() -> this.api.findDropletByApplicationGuid(appId)).map((? super T apiDroplet) -> CloudFoundryDroplet.builder().id(apiDroplet.getGuid()).name(application.getName() + "-droplet").stack(apiDroplet.getStack()).buildpacks(((Collection)Optional.ofNullable(apiDroplet.getBuildpacks()).orElse(Collections.emptyList())).stream().map((? super T bp) -> CloudFoundryBuildpack.builder().name(bp.getName()).detectOutput(bp.getDetectOutput()).version(bp.getVersion()).buildpackName(bp.getBuildpackName()).build()).collect(Collectors.toList())).space(space).sourcePackage(cfPackage).build()).orElse(null);
        }
        catch (Exception ex) {
            log.debug("Unable to retrieve droplet for application '" + application.getName() + "'");
        }
        List<CloudFoundryServiceInstance> cloudFoundryServices = applicationEnv == null ? Collections.emptyList() : applicationEnv.getSystemEnvJson().getVcapServices().entrySet().stream().flatMap(vcap -> ((List)vcap.getValue()).stream().map((? super T instance) -> {
            CloudFoundryServiceInstance.CloudFoundryServiceInstanceBuilder cloudFoundryServiceInstanceBuilder = CloudFoundryServiceInstance.builder().serviceInstanceName((String)vcap.getKey()).name(instance.getName()).plan(instance.getPlan()).tags(instance.getTags());
            if (instance.getLastOperation() != null && instance.getLastOperation().getState() != null) {
                cloudFoundryServiceInstanceBuilder.status(instance.getLastOperation().getState().toString()).lastOperationDescription(instance.getLastOperation().getDescription());
            }
            return cloudFoundryServiceInstanceBuilder.build();
        })).collect(Collectors.toList());
        Map<String, Object> environmentVars = applicationEnv == null || applicationEnv.getEnvironmentJson() == null ? Collections.emptyMap() : applicationEnv.getEnvironmentJson();
        environmentVars = environmentVars.entrySet().stream().filter(e -> ServerGroupMetaDataEnvVar.contains((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        CloudFoundryBuildInfo buildInfo = this.getBuildInfoFromEnvVars(environmentVars);
        ArtifactInfo artifactInfo = this.getArtifactInfoFromEnvVars(environmentVars);
        String pipelineId = this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.PipelineId);
        String healthCheckType = null;
        String healthCheckHttpEndpoint = null;
        if (process != null && process.getHealthCheck() != null) {
            Process.HealthCheck healthCheck = process.getHealthCheck();
            healthCheckType = healthCheck.getType();
            if (healthCheck.getData() != null) {
                healthCheckHttpEndpoint = healthCheck.getData().getEndpoint();
            }
        }
        String serverGroupAppManagerUri = this.appsManagerUri;
        if (StringUtils.isNotEmpty((CharSequence)this.appsManagerUri)) {
            serverGroupAppManagerUri = Optional.ofNullable(space).map((? super T s) -> this.appsManagerUri + "/organizations/" + s.getOrganization().getId() + "/spaces/" + s.getId() + "/applications/" + appId).orElse("");
        }
        Object serverGroupMetricsUri = this.metricsUri;
        if (StringUtils.isNotEmpty((CharSequence)this.metricsUri)) {
            serverGroupMetricsUri = this.metricsUri + "/apps/" + appId;
        }
        CloudFoundryServerGroup cloudFoundryServerGroup = CloudFoundryServerGroup.builder().account(this.account).appsManagerUri(serverGroupAppManagerUri).metricsUri((String)serverGroupMetricsUri).name(application.getName()).id(appId).memory(process != null ? Integer.valueOf(process.getMemoryInMb()) : null).instances(Collections.emptySet()).droplet(droplet).diskQuota(process != null ? Integer.valueOf(process.getDiskInMb()) : null).healthCheckType(healthCheckType).healthCheckHttpEndpoint(healthCheckHttpEndpoint).space(space).createdTime(application.getCreatedAt().toInstant().toEpochMilli()).serviceInstances(cloudFoundryServices).state(state).env(environmentVars).ciBuild(buildInfo).appArtifact(artifactInfo).pipelineId(pipelineId).updatedTime(application.getUpdatedAt().toInstant().toEpochMilli()).build();
        return Optional.of(this.checkHealthStatus(cloudFoundryServerGroup, application));
    }

    private CloudFoundryServerGroup checkHealthStatus(CloudFoundryServerGroup cloudFoundryServerGroup, com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Application application) {
        Set<CloudFoundryInstance> instances;
        CloudFoundryServerGroup.State state = CloudFoundryServerGroup.State.valueOf(application.getState());
        switch (state) {
            case STARTED: {
                try {
                    instances = CloudFoundryClientUtils.safelyCall(() -> this.api.instances(cloudFoundryServerGroup.getId())).orElse(Collections.emptyMap()).entrySet().stream().map((? super T inst) -> {
                        HealthState healthState = HealthState.Unknown;
                        switch (((InstanceStatus)inst.getValue()).getState()) {
                            case RUNNING: {
                                healthState = HealthState.Up;
                                break;
                            }
                            case DOWN: 
                            case CRASHED: {
                                healthState = HealthState.Down;
                                break;
                            }
                            case STARTING: {
                                healthState = HealthState.Starting;
                            }
                        }
                        return CloudFoundryInstance.builder().appGuid(cloudFoundryServerGroup.getId()).key((String)inst.getKey()).healthState(healthState).details(((InstanceStatus)inst.getValue()).getDetails()).launchTime(System.currentTimeMillis() - ((InstanceStatus)inst.getValue()).getUptime() * 1000L).zone(cloudFoundryServerGroup.getRegion()).build();
                    }).collect(Collectors.toSet());
                    log.trace("Successfully retrieved " + instances.size() + " instances for application '" + application.getName() + "'");
                }
                catch (Exception ex) {
                    log.debug("Unable to retrieve droplet for application '" + application.getName() + "'");
                    instances = Collections.emptySet();
                }
                break;
            }
            default: {
                instances = Collections.emptySet();
            }
        }
        return cloudFoundryServerGroup.toBuilder().state(state).instances(instances).build();
    }

    private String getEnvironmentVar(Map<String, Object> environmentVars, ServerGroupMetaDataEnvVar var) {
        return Optional.ofNullable(environmentVars.get(var.envVarName)).map(Object::toString).orElse(null);
    }

    private CloudFoundryBuildInfo getBuildInfoFromEnvVars(Map<String, Object> environmentVars) {
        return CloudFoundryBuildInfo.builder().jobName(this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.JobName)).jobNumber(this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.JobNumber)).jobUrl(this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.JobUrl)).build();
    }

    private ArtifactInfo getArtifactInfoFromEnvVars(Map<String, Object> environmentVars) {
        return ArtifactInfo.builder().name(this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.ArtifactName)).version(this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.ArtifactVersion)).url(this.getEnvironmentVar(environmentVars, ServerGroupMetaDataEnvVar.ArtifactUrl)).build();
    }

    public void mapRoute(String applicationGuid, String routeGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.mapRoute(applicationGuid, routeGuid, new MapRoute()));
    }

    public void unmapRoute(String applicationGuid, String routeGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.unmapRoute(applicationGuid, routeGuid));
    }

    public void startApplication(String applicationGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.startApplication(applicationGuid, new StartApplication()));
    }

    public void stopApplication(String applicationGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.stopApplication(applicationGuid, new StopApplication()));
    }

    public void deleteApplication(String applicationGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.deleteApplication(applicationGuid));
    }

    public void deleteAppInstance(String guid, String index) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.deleteAppInstance(guid, index));
    }

    public CloudFoundryServerGroup createApplication(String appName, CloudFoundrySpace space, @Nullable Map<String, String> environmentVariables, Lifecycle lifecycle) throws CloudFoundryApiException {
        HashMap<String, ToOneRelationship> relationships = new HashMap<String, ToOneRelationship>();
        relationships.put("space", new ToOneRelationship(new Relationship(space.getId())));
        return (CloudFoundryServerGroup)CloudFoundryClientUtils.safelyCall(() -> this.api.createApplication(new CreateApplication(appName, relationships, environmentVariables, lifecycle))).map(this::map).flatMap(sg -> sg).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cloud Foundry signaled that application creation succeeded but failed to provide a response."}));
    }

    public String createPackage(CreatePackage createPackageRequest) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.safelyCall(() -> this.api.createPackage(createPackageRequest)).map(Package::getGuid).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cloud Foundry signaled that package creation succeeded but failed to provide a response."}));
    }

    @Nullable
    public String findCurrentPackageIdByAppId(String appGuid) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.safelyCall(() -> this.api.findDropletByApplicationGuid(appGuid)).map((? super T droplet) -> StringUtils.substringAfterLast((String)droplet.getLinks().get("package").getHref(), (String)"/")).orElse(null);
    }

    @Nonnull
    public InputStream downloadPackageBits(String packageGuid) throws CloudFoundryApiException {
        Optional<InputStream> optionalPackageInput = CloudFoundryClientUtils.safelyCall(() -> this.api.downloadPackage(packageGuid)).map(ResponseBody::byteStream);
        return optionalPackageInput.orElseThrow(() -> new CloudFoundryApiException(new String[]{"Failed to retrieve input stream of package bits."}));
    }

    public void uploadPackageBits(String packageGuid, File file) throws CloudFoundryApiException {
        MultipartBody.Part filePart = MultipartBody.Part.createFormData((String)"bits", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)file));
        CloudFoundryClientUtils.safelyCall(() -> this.api.uploadPackageBits(packageGuid, filePart)).map(Package::getGuid).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cloud Foundry signaled that package upload succeeded but failed to provide a response."}));
    }

    public String createBuild(String packageGuid, @Nullable Integer memoryAmount, @Nullable Integer diskSizeAmount) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.safelyCall(() -> this.api.createBuild(new CreateBuild(packageGuid, memoryAmount, diskSizeAmount))).map(Build::getGuid).orElseThrow(() -> new CloudFoundryApiException(new String[]{"Cloud Foundry signaled that build creation succeeded but failed to provide a response."}));
    }

    public Boolean buildCompleted(String buildGuid) throws CloudFoundryApiException {
        switch (CloudFoundryClientUtils.safelyCall(() -> this.api.getBuild(buildGuid)).map(Build::getState).orElse(Build.State.FAILED)) {
            case FAILED: {
                throw new CloudFoundryApiException(new String[]{"Failed to build droplet or there are not enough resources available"});
            }
            case STAGED: {
                return true;
            }
        }
        return false;
    }

    public boolean packageUploadComplete(String packageGuid) throws CloudFoundryApiException {
        switch (CloudFoundryClientUtils.safelyCall(() -> this.api.getPackage(packageGuid)).map(Package::getState).orElse(Package.State.FAILED)) {
            case FAILED: 
            case EXPIRED: {
                throw new CloudFoundryApiException(new String[]{"Upload failed"});
            }
            case READY: {
                return true;
            }
        }
        return false;
    }

    public String findDropletGuidFromBuildId(String buildGuid) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.safelyCall(() -> this.api.getBuild(buildGuid)).map(Build::getDroplet).map(Droplet::getGuid).orElse(null);
    }

    public void setCurrentDroplet(String appGuid, String dropletGuid) throws CloudFoundryApiException {
        CloudFoundryClientUtils.safelyCall(() -> this.api.setCurrentDroplet(appGuid, new ToOneRelationship(new Relationship(dropletGuid))));
    }

    public List<Resource<Application>> getTakenSlots(String clusterName, String spaceId) {
        String finalName = this.buildFinalAsgName(clusterName);
        List<String> filter = Arrays.asList("name<=" + finalName, "name>=" + clusterName, "space_guid:" + spaceId);
        return CloudFoundryClientUtils.collectPageResources("applications", page -> this.api.listAppsFiltered((Integer)page, filter, 10)).stream().filter(app -> {
            Names entityNames = Names.parseName((String)((Application)app.getEntity()).getName());
            return clusterName.equals(entityNames.getCluster());
        }).collect(Collectors.toList());
    }

    private String buildFinalAsgName(String clusterName) {
        Names names = Names.parseName((String)clusterName);
        return AbstractServerGroupNameResolver.generateServerGroupName((String)names.getApp(), (String)names.getStack(), (String)names.getDetail(), (Integer)999, (Boolean)false);
    }

    public void restageApplication(String appGuid) {
        CloudFoundryClientUtils.safelyCall(() -> this.api.restageApplication(appGuid, ""));
    }

    public ProcessStats.State getAppState(String guid) {
        return this.processes.getProcessState(guid).orElseGet(() -> CloudFoundryClientUtils.safelyCall(() -> this.api.findById(guid)).filter(application -> CloudFoundryServerGroup.State.STARTED.equals((Object)CloudFoundryServerGroup.State.valueOf(application.getState()))).map((? super T appState) -> ProcessStats.State.RUNNING).orElse(ProcessStats.State.DOWN));
    }

    public List<Resource<ServiceBinding>> getServiceBindingsByApp(String appGuid) {
        return CloudFoundryClientUtils.collectPageResources("service bindings", pg -> this.api.getServiceBindings(appGuid));
    }
}

