/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class Page<R> {
    private int totalResults;
    private int totalPages;
    private List<Resource<R>> resources = Collections.emptyList();

    public static <R> Page<R> singleton(R data, String resourceId) {
        Page<R> page = new Page<R>();
        page.setTotalPages(1);
        page.setTotalResults(1);
        Resource.Metadata metadata = new Resource.Metadata();
        metadata.setGuid(resourceId);
        Resource<R> resource = new Resource<R>();
        resource.setMetadata(metadata);
        resource.setEntity(data);
        page.setResources(Collections.singletonList(resource));
        return page;
    }

    public static <R> Page<R> asPage(R ... data) {
        Page<R> page = new Page<R>();
        page.setTotalPages(1);
        page.setTotalResults(data.length);
        page.setResources(Arrays.stream(data).map(d -> {
            Resource.Metadata metadata = new Resource.Metadata();
            metadata.setGuid(UUID.randomUUID().toString());
            Resource<Object> resource = new Resource<Object>();
            resource.setMetadata(metadata);
            resource.setEntity(d);
            return resource;
        }).collect(Collectors.toList()));
        return page;
    }

    @Generated
    public Page() {
    }

    @Generated
    public int getTotalResults() {
        return this.totalResults;
    }

    @Generated
    public int getTotalPages() {
        return this.totalPages;
    }

    @Generated
    public List<Resource<R>> getResources() {
        return this.resources;
    }

    @Generated
    public Page<R> setTotalResults(int totalResults) {
        this.totalResults = totalResults;
        return this;
    }

    @Generated
    public Page<R> setTotalPages(int totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    @Generated
    public Page<R> setResources(List<Resource<R>> resources) {
        this.resources = resources;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Page)) {
            return false;
        }
        Page other = (Page)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalResults() != other.getTotalResults()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        List<Resource<R>> this$resources = this.getResources();
        List<Resource<R>> other$resources = other.getResources();
        return !(this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Page;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalResults();
        result = result * 59 + this.getTotalPages();
        List<Resource<R>> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Page(totalResults=" + this.getTotalResults() + ", totalPages=" + this.getTotalPages() + ", resources=" + String.valueOf(this.getResources()) + ")";
    }
}

