/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.retry;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(RetryInterceptor.class);
    private final int maxAttempts;

    public RetryInterceptor(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        String callName = "cf.api.call";
        AtomicInteger currentAttempts = new AtomicInteger();
        Retry retry = Retry.of((String)"cf.api.call", (RetryConfig)RetryConfig.custom().maxAttempts(this.maxAttempts).intervalFunction((IntervalFunction)io.github.resilience4j.retry.IntervalFunction.ofExponentialBackoff((Duration)Duration.ofSeconds(10L), (double)3.0)).retryExceptions(new Class[]{SocketTimeoutException.class, RetryableApiException.class}).build());
        this.logger.trace("cf request: " + String.valueOf(chain.request().url()));
        AtomicReference lastResponse = new AtomicReference();
        try {
            return (Response)retry.executeCallable(() -> {
                currentAttempts.incrementAndGet();
                Response response = chain.proceed(chain.request());
                lastResponse.set(response);
                switch (response.code()) {
                    case 502: 
                    case 503: 
                    case 504: {
                        if (currentAttempts.get() < this.maxAttempts) {
                            response.close();
                        }
                        throw new RetryableApiException("Response Code " + response.code() + ": " + String.valueOf(chain.request().url()) + " attempting retry");
                    }
                }
                return response;
            });
        }
        catch (Exception e) {
            Response response = (Response)lastResponse.get();
            if (response == null) {
                throw new IllegalStateException(e);
            }
            return response;
        }
    }

    private static class RetryableApiException
    extends RuntimeException {
        RetryableApiException(String message) {
            super(message);
        }
    }
}

