/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.Token;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.tokens.AccessTokenProvider;
import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.jetbrains.annotations.Nullable;

public class AccessTokenAuthenticator
implements Authenticator {
    private final AccessTokenProvider accessTokenProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Request authenticate(@Nullable Route route, Response response) throws IOException {
        Token currentToken = this.accessTokenProvider.getAccessToken();
        Object object = this.accessTokenProvider.getTokenLock();
        synchronized (object) {
            Token newToken = this.accessTokenProvider.getAccessToken();
            if (!currentToken.equals(newToken)) {
                return this.newRequestWithAccessToken(response.request(), newToken);
            }
            this.accessTokenProvider.refreshAccessToken();
            Token updatedToken = this.accessTokenProvider.getAccessToken();
            return this.newRequestWithAccessToken(response.request(), updatedToken);
        }
    }

    @NonNull
    private Request newRequestWithAccessToken(@NonNull Request request, @NonNull Token token) {
        if (request == null) {
            throw new IllegalArgumentException("request is marked non-null but is null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token is marked non-null but is null");
        }
        return request.newBuilder().header("Authorization", "Bearer " + token.getAccessToken()).build();
    }

    @Generated
    public AccessTokenProvider getAccessTokenProvider() {
        return this.accessTokenProvider;
    }

    @Generated
    public AccessTokenAuthenticator(AccessTokenProvider accessTokenProvider) {
        this.accessTokenProvider = accessTokenProvider;
    }
}

