/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.config;

import com.netflix.spinnaker.credentials.definition.CredentialsDefinition;
import com.netflix.spinnaker.fiat.model.resources.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(value="cloudfoundry")
public class CloudFoundryConfigurationProperties
implements DisposableBean {
    static final int POLLING_INTERVAL_MILLISECONDS_DEFAULT = 300000;
    static final int ASYNC_OPERATION_TIMEOUT_MILLISECONDS_DEFAULT = 450000;
    static final int ASYNC_OPERATION_MAX_POLLING_INTERVAL_MILLISECONDS = 8000;
    private int pollingIntervalMilliseconds = 300000;
    private int asyncOperationTimeoutMillisecondsDefault = 450000;
    private int asyncOperationMaxPollingIntervalMilliseconds = 8000;
    private List<ManagedAccount> accounts = new ArrayList<ManagedAccount>();
    private int apiRequestParallelism = 100;
    @NestedConfigurationProperty
    private ClientConfig client = new ClientConfig();
    @NestedConfigurationProperty
    private LocalCacheConfig localCacheConfig = new LocalCacheConfig();

    public void destroy() {
        this.accounts = new ArrayList<ManagedAccount>();
    }

    @Generated
    public CloudFoundryConfigurationProperties() {
    }

    @Generated
    public int getPollingIntervalMilliseconds() {
        return this.pollingIntervalMilliseconds;
    }

    @Generated
    public int getAsyncOperationTimeoutMillisecondsDefault() {
        return this.asyncOperationTimeoutMillisecondsDefault;
    }

    @Generated
    public int getAsyncOperationMaxPollingIntervalMilliseconds() {
        return this.asyncOperationMaxPollingIntervalMilliseconds;
    }

    @Generated
    public List<ManagedAccount> getAccounts() {
        return this.accounts;
    }

    @Generated
    public int getApiRequestParallelism() {
        return this.apiRequestParallelism;
    }

    @Generated
    public ClientConfig getClient() {
        return this.client;
    }

    @Generated
    public LocalCacheConfig getLocalCacheConfig() {
        return this.localCacheConfig;
    }

    @Generated
    public CloudFoundryConfigurationProperties setPollingIntervalMilliseconds(int pollingIntervalMilliseconds) {
        this.pollingIntervalMilliseconds = pollingIntervalMilliseconds;
        return this;
    }

    @Generated
    public CloudFoundryConfigurationProperties setAsyncOperationTimeoutMillisecondsDefault(int asyncOperationTimeoutMillisecondsDefault) {
        this.asyncOperationTimeoutMillisecondsDefault = asyncOperationTimeoutMillisecondsDefault;
        return this;
    }

    @Generated
    public CloudFoundryConfigurationProperties setAsyncOperationMaxPollingIntervalMilliseconds(int asyncOperationMaxPollingIntervalMilliseconds) {
        this.asyncOperationMaxPollingIntervalMilliseconds = asyncOperationMaxPollingIntervalMilliseconds;
        return this;
    }

    @Generated
    public CloudFoundryConfigurationProperties setAccounts(List<ManagedAccount> accounts) {
        this.accounts = accounts;
        return this;
    }

    @Generated
    public CloudFoundryConfigurationProperties setApiRequestParallelism(int apiRequestParallelism) {
        this.apiRequestParallelism = apiRequestParallelism;
        return this;
    }

    @Generated
    public CloudFoundryConfigurationProperties setClient(ClientConfig client) {
        this.client = client;
        return this;
    }

    @Generated
    public CloudFoundryConfigurationProperties setLocalCacheConfig(LocalCacheConfig localCacheConfig) {
        this.localCacheConfig = localCacheConfig;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryConfigurationProperties)) {
            return false;
        }
        CloudFoundryConfigurationProperties other = (CloudFoundryConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPollingIntervalMilliseconds() != other.getPollingIntervalMilliseconds()) {
            return false;
        }
        if (this.getAsyncOperationTimeoutMillisecondsDefault() != other.getAsyncOperationTimeoutMillisecondsDefault()) {
            return false;
        }
        if (this.getAsyncOperationMaxPollingIntervalMilliseconds() != other.getAsyncOperationMaxPollingIntervalMilliseconds()) {
            return false;
        }
        if (this.getApiRequestParallelism() != other.getApiRequestParallelism()) {
            return false;
        }
        List<ManagedAccount> this$accounts = this.getAccounts();
        List<ManagedAccount> other$accounts = other.getAccounts();
        if (this$accounts == null ? other$accounts != null : !((Object)this$accounts).equals(other$accounts)) {
            return false;
        }
        ClientConfig this$client = this.getClient();
        ClientConfig other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        LocalCacheConfig this$localCacheConfig = this.getLocalCacheConfig();
        LocalCacheConfig other$localCacheConfig = other.getLocalCacheConfig();
        return !(this$localCacheConfig == null ? other$localCacheConfig != null : !((Object)this$localCacheConfig).equals(other$localCacheConfig));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudFoundryConfigurationProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPollingIntervalMilliseconds();
        result = result * 59 + this.getAsyncOperationTimeoutMillisecondsDefault();
        result = result * 59 + this.getAsyncOperationMaxPollingIntervalMilliseconds();
        result = result * 59 + this.getApiRequestParallelism();
        List<ManagedAccount> $accounts = this.getAccounts();
        result = result * 59 + ($accounts == null ? 43 : ((Object)$accounts).hashCode());
        ClientConfig $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        LocalCacheConfig $localCacheConfig = this.getLocalCacheConfig();
        result = result * 59 + ($localCacheConfig == null ? 43 : ((Object)$localCacheConfig).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CloudFoundryConfigurationProperties(pollingIntervalMilliseconds=" + this.getPollingIntervalMilliseconds() + ", asyncOperationTimeoutMillisecondsDefault=" + this.getAsyncOperationTimeoutMillisecondsDefault() + ", asyncOperationMaxPollingIntervalMilliseconds=" + this.getAsyncOperationMaxPollingIntervalMilliseconds() + ", accounts=" + String.valueOf(this.getAccounts()) + ", apiRequestParallelism=" + this.getApiRequestParallelism() + ", client=" + String.valueOf(this.getClient()) + ", localCacheConfig=" + String.valueOf(this.getLocalCacheConfig()) + ")";
    }

    public static class ClientConfig {
        private int connectionTimeout = 10000;
        private int writeTimeout = 10000;
        private int readTimeout = 10000;
        private int maxRetries = 3;

        @Generated
        public ClientConfig() {
        }

        @Generated
        public int getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Generated
        public int getWriteTimeout() {
            return this.writeTimeout;
        }

        @Generated
        public int getReadTimeout() {
            return this.readTimeout;
        }

        @Generated
        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Generated
        public ClientConfig setConnectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Generated
        public ClientConfig setWriteTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        @Generated
        public ClientConfig setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Generated
        public ClientConfig setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClientConfig)) {
                return false;
            }
            ClientConfig other = (ClientConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
                return false;
            }
            if (this.getWriteTimeout() != other.getWriteTimeout()) {
                return false;
            }
            if (this.getReadTimeout() != other.getReadTimeout()) {
                return false;
            }
            return this.getMaxRetries() == other.getMaxRetries();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ClientConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getConnectionTimeout();
            result = result * 59 + this.getWriteTimeout();
            result = result * 59 + this.getReadTimeout();
            result = result * 59 + this.getMaxRetries();
            return result;
        }

        @Generated
        public String toString() {
            return "CloudFoundryConfigurationProperties.ClientConfig(connectionTimeout=" + this.getConnectionTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", readTimeout=" + this.getReadTimeout() + ", maxRetries=" + this.getMaxRetries() + ")";
        }
    }

    public static class LocalCacheConfig {
        private long applicationsAccessExpirySeconds = -1L;
        private long applicationsWriteExpirySeconds = 600L;
        private long routesAccessExpirySeconds = -1L;
        private long routesWriteExpirySeconds = 180L;

        @Generated
        public LocalCacheConfig() {
        }

        @Generated
        public long getApplicationsAccessExpirySeconds() {
            return this.applicationsAccessExpirySeconds;
        }

        @Generated
        public long getApplicationsWriteExpirySeconds() {
            return this.applicationsWriteExpirySeconds;
        }

        @Generated
        public long getRoutesAccessExpirySeconds() {
            return this.routesAccessExpirySeconds;
        }

        @Generated
        public long getRoutesWriteExpirySeconds() {
            return this.routesWriteExpirySeconds;
        }

        @Generated
        public LocalCacheConfig setApplicationsAccessExpirySeconds(long applicationsAccessExpirySeconds) {
            this.applicationsAccessExpirySeconds = applicationsAccessExpirySeconds;
            return this;
        }

        @Generated
        public LocalCacheConfig setApplicationsWriteExpirySeconds(long applicationsWriteExpirySeconds) {
            this.applicationsWriteExpirySeconds = applicationsWriteExpirySeconds;
            return this;
        }

        @Generated
        public LocalCacheConfig setRoutesAccessExpirySeconds(long routesAccessExpirySeconds) {
            this.routesAccessExpirySeconds = routesAccessExpirySeconds;
            return this;
        }

        @Generated
        public LocalCacheConfig setRoutesWriteExpirySeconds(long routesWriteExpirySeconds) {
            this.routesWriteExpirySeconds = routesWriteExpirySeconds;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalCacheConfig)) {
                return false;
            }
            LocalCacheConfig other = (LocalCacheConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getApplicationsAccessExpirySeconds() != other.getApplicationsAccessExpirySeconds()) {
                return false;
            }
            if (this.getApplicationsWriteExpirySeconds() != other.getApplicationsWriteExpirySeconds()) {
                return false;
            }
            if (this.getRoutesAccessExpirySeconds() != other.getRoutesAccessExpirySeconds()) {
                return false;
            }
            return this.getRoutesWriteExpirySeconds() == other.getRoutesWriteExpirySeconds();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LocalCacheConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $applicationsAccessExpirySeconds = this.getApplicationsAccessExpirySeconds();
            result = result * 59 + (int)($applicationsAccessExpirySeconds >>> 32 ^ $applicationsAccessExpirySeconds);
            long $applicationsWriteExpirySeconds = this.getApplicationsWriteExpirySeconds();
            result = result * 59 + (int)($applicationsWriteExpirySeconds >>> 32 ^ $applicationsWriteExpirySeconds);
            long $routesAccessExpirySeconds = this.getRoutesAccessExpirySeconds();
            result = result * 59 + (int)($routesAccessExpirySeconds >>> 32 ^ $routesAccessExpirySeconds);
            long $routesWriteExpirySeconds = this.getRoutesWriteExpirySeconds();
            result = result * 59 + (int)($routesWriteExpirySeconds >>> 32 ^ $routesWriteExpirySeconds);
            return result;
        }

        @Generated
        public String toString() {
            return "CloudFoundryConfigurationProperties.LocalCacheConfig(applicationsAccessExpirySeconds=" + this.getApplicationsAccessExpirySeconds() + ", applicationsWriteExpirySeconds=" + this.getApplicationsWriteExpirySeconds() + ", routesAccessExpirySeconds=" + this.getRoutesAccessExpirySeconds() + ", routesWriteExpirySeconds=" + this.getRoutesWriteExpirySeconds() + ")";
        }
    }

    public static class ManagedAccount
    implements CredentialsDefinition {
        private String name;
        private String api;
        private String appsManagerUri;
        private String metricsUri;
        private String user;
        private String password;
        private String environment;
        private boolean skipSslValidation;
        private boolean onlySpinnakerManaged;
        private Integer resultsPerPage;
        @Deprecated
        private Integer maxCapiConnectionsForCache;
        private Permissions.Builder permissions = new Permissions.Builder();
        private Map<String, Set<String>> spaceFilter = Collections.emptyMap();

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getApi() {
            return this.api;
        }

        @Generated
        public String getAppsManagerUri() {
            return this.appsManagerUri;
        }

        @Generated
        public String getMetricsUri() {
            return this.metricsUri;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public String getEnvironment() {
            return this.environment;
        }

        @Generated
        public boolean isSkipSslValidation() {
            return this.skipSslValidation;
        }

        @Generated
        public boolean isOnlySpinnakerManaged() {
            return this.onlySpinnakerManaged;
        }

        @Generated
        public Integer getResultsPerPage() {
            return this.resultsPerPage;
        }

        @Deprecated
        @Generated
        public Integer getMaxCapiConnectionsForCache() {
            return this.maxCapiConnectionsForCache;
        }

        @Generated
        public Permissions.Builder getPermissions() {
            return this.permissions;
        }

        @Generated
        public Map<String, Set<String>> getSpaceFilter() {
            return this.spaceFilter;
        }

        @Generated
        public ManagedAccount setName(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ManagedAccount setApi(String api) {
            this.api = api;
            return this;
        }

        @Generated
        public ManagedAccount setAppsManagerUri(String appsManagerUri) {
            this.appsManagerUri = appsManagerUri;
            return this;
        }

        @Generated
        public ManagedAccount setMetricsUri(String metricsUri) {
            this.metricsUri = metricsUri;
            return this;
        }

        @Generated
        public ManagedAccount setUser(String user) {
            this.user = user;
            return this;
        }

        @Generated
        public ManagedAccount setPassword(String password) {
            this.password = password;
            return this;
        }

        @Generated
        public ManagedAccount setEnvironment(String environment) {
            this.environment = environment;
            return this;
        }

        @Generated
        public ManagedAccount setSkipSslValidation(boolean skipSslValidation) {
            this.skipSslValidation = skipSslValidation;
            return this;
        }

        @Generated
        public ManagedAccount setOnlySpinnakerManaged(boolean onlySpinnakerManaged) {
            this.onlySpinnakerManaged = onlySpinnakerManaged;
            return this;
        }

        @Generated
        public ManagedAccount setResultsPerPage(Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @Deprecated
        @Generated
        public ManagedAccount setMaxCapiConnectionsForCache(Integer maxCapiConnectionsForCache) {
            this.maxCapiConnectionsForCache = maxCapiConnectionsForCache;
            return this;
        }

        @Generated
        public ManagedAccount setPermissions(Permissions.Builder permissions) {
            this.permissions = permissions;
            return this;
        }

        @Generated
        public ManagedAccount setSpaceFilter(Map<String, Set<String>> spaceFilter) {
            this.spaceFilter = spaceFilter;
            return this;
        }

        @Generated
        public String toString() {
            return "CloudFoundryConfigurationProperties.ManagedAccount(name=" + this.getName() + ", api=" + this.getApi() + ", appsManagerUri=" + this.getAppsManagerUri() + ", metricsUri=" + this.getMetricsUri() + ", user=" + this.getUser() + ", environment=" + this.getEnvironment() + ", skipSslValidation=" + this.isSkipSslValidation() + ", onlySpinnakerManaged=" + this.isOnlySpinnakerManaged() + ", resultsPerPage=" + this.getResultsPerPage() + ", maxCapiConnectionsForCache=" + this.getMaxCapiConnectionsForCache() + ", permissions=" + String.valueOf(this.getPermissions()) + ", spaceFilter=" + String.valueOf(this.getSpaceFilter()) + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ManagedAccount)) {
                return false;
            }
            ManagedAccount other = (ManagedAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSkipSslValidation() != other.isSkipSslValidation()) {
                return false;
            }
            if (this.isOnlySpinnakerManaged() != other.isOnlySpinnakerManaged()) {
                return false;
            }
            Integer this$resultsPerPage = this.getResultsPerPage();
            Integer other$resultsPerPage = other.getResultsPerPage();
            if (this$resultsPerPage == null ? other$resultsPerPage != null : !((Object)this$resultsPerPage).equals(other$resultsPerPage)) {
                return false;
            }
            Integer this$maxCapiConnectionsForCache = this.getMaxCapiConnectionsForCache();
            Integer other$maxCapiConnectionsForCache = other.getMaxCapiConnectionsForCache();
            if (this$maxCapiConnectionsForCache == null ? other$maxCapiConnectionsForCache != null : !((Object)this$maxCapiConnectionsForCache).equals(other$maxCapiConnectionsForCache)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$api = this.getApi();
            String other$api = other.getApi();
            if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
                return false;
            }
            String this$appsManagerUri = this.getAppsManagerUri();
            String other$appsManagerUri = other.getAppsManagerUri();
            if (this$appsManagerUri == null ? other$appsManagerUri != null : !this$appsManagerUri.equals(other$appsManagerUri)) {
                return false;
            }
            String this$metricsUri = this.getMetricsUri();
            String other$metricsUri = other.getMetricsUri();
            if (this$metricsUri == null ? other$metricsUri != null : !this$metricsUri.equals(other$metricsUri)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$environment = this.getEnvironment();
            String other$environment = other.getEnvironment();
            if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
                return false;
            }
            Permissions.Builder this$permissions = this.getPermissions();
            Permissions.Builder other$permissions = other.getPermissions();
            if (this$permissions == null ? other$permissions != null : !this$permissions.equals(other$permissions)) {
                return false;
            }
            Map<String, Set<String>> this$spaceFilter = this.getSpaceFilter();
            Map<String, Set<String>> other$spaceFilter = other.getSpaceFilter();
            return !(this$spaceFilter == null ? other$spaceFilter != null : !((Object)this$spaceFilter).equals(other$spaceFilter));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ManagedAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSkipSslValidation() ? 79 : 97);
            result = result * 59 + (this.isOnlySpinnakerManaged() ? 79 : 97);
            Integer $resultsPerPage = this.getResultsPerPage();
            result = result * 59 + ($resultsPerPage == null ? 43 : ((Object)$resultsPerPage).hashCode());
            Integer $maxCapiConnectionsForCache = this.getMaxCapiConnectionsForCache();
            result = result * 59 + ($maxCapiConnectionsForCache == null ? 43 : ((Object)$maxCapiConnectionsForCache).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $api = this.getApi();
            result = result * 59 + ($api == null ? 43 : $api.hashCode());
            String $appsManagerUri = this.getAppsManagerUri();
            result = result * 59 + ($appsManagerUri == null ? 43 : $appsManagerUri.hashCode());
            String $metricsUri = this.getMetricsUri();
            result = result * 59 + ($metricsUri == null ? 43 : $metricsUri.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $environment = this.getEnvironment();
            result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
            Permissions.Builder $permissions = this.getPermissions();
            result = result * 59 + ($permissions == null ? 43 : $permissions.hashCode());
            Map<String, Set<String>> $spaceFilter = this.getSpaceFilter();
            result = result * 59 + ($spaceFilter == null ? 43 : ((Object)$spaceFilter).hashCode());
            return result;
        }
    }
}

