/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryServerGroupAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.LoadBalancersDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
abstract class AbstractLoadBalancersAtomicOperationConverter
extends AbstractCloudFoundryServerGroupAtomicOperationConverter {
    AbstractLoadBalancersAtomicOperationConverter() {
    }

    public LoadBalancersDescription convertDescription(Map input) {
        List routes = (List)input.get("loadBalancerNames");
        if (routes.isEmpty()) {
            throw new IllegalArgumentException("No routes supplied.");
        }
        LoadBalancersDescription converted = (LoadBalancersDescription)this.getObjectMapper().convertValue((Object)input, LoadBalancersDescription.class);
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        converted.setClient(this.getClient(input));
        converted.setServerGroupId(this.getServerGroupId(converted.getServerGroupName(), converted.getRegion(), converted.getClient()));
        converted.setRoutes(routes);
        return this.findSpace(converted.getRegion(), converted.getClient()).map(converted::setSpace).orElseThrow(() -> new IllegalArgumentException("No space supplied."));
    }
}

