/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters;

import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.RouteId;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.converters.AbstractCloudFoundryAtomicOperationConverter;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeleteCloudFoundryLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.DeleteCloudFoundryLoadBalancerAtomicOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@CloudFoundryOperation(value="deleteLoadBalancer")
@Component
public class DeleteCloudFoundryLoadBalancerAtomicOperationConverter
extends AbstractCloudFoundryAtomicOperationConverter {
    public AtomicOperation convertOperation(Map input) {
        return new DeleteCloudFoundryLoadBalancerAtomicOperation(this.convertDescription(input));
    }

    public DeleteCloudFoundryLoadBalancerDescription convertDescription(Map input) {
        DeleteCloudFoundryLoadBalancerDescription converted = (DeleteCloudFoundryLoadBalancerDescription)this.getObjectMapper().convertValue((Object)input, DeleteCloudFoundryLoadBalancerDescription.class);
        converted.setClient(this.getClient(input));
        CloudFoundryCredentials credentials = (CloudFoundryCredentials)this.getCredentialsObject(input.get("credentials").toString());
        converted.setCredentials(credentials);
        CloudFoundryClient client = converted.getClient();
        return ((Collection)input.get("regions")).stream().map(region -> this.findSpace((String)region, client)).filter(Optional::isPresent).findFirst().flatMap(Function.identity()).map(space -> {
            String routePath = input.get("loadBalancerName").toString();
            RouteId routeId = client.getRoutes().toRouteId(routePath);
            if (routeId == null) {
                throw new IllegalArgumentException("Invalid format or domain for route '" + routePath + "'");
            }
            converted.setRegion(space.getRegion());
            converted.setSpace((CloudFoundrySpace)space);
            return converted.setLoadBalancer(client.getRoutes().find(routeId, space.getId()));
        }).orElseThrow(() -> new IllegalArgumentException("Unable to find the space(s) that this load balancer was expected to be in."));
    }
}

