/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceInstanceResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.ShareCloudFoundryServiceDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class ShareCloudFoundryServiceAtomicOperation
implements AtomicOperation<ServiceInstanceResponse> {
    private static final String PHASE = "SHARE_SERVICE";
    private final ShareCloudFoundryServiceDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public ServiceInstanceResponse operate(List priorOutputs) {
        Task task = ShareCloudFoundryServiceAtomicOperation.getTask();
        String serviceInstanceName = this.description.getServiceInstanceName();
        String region = this.description.getRegion();
        Set<String> shareToRegions = this.description.getShareToRegions();
        task.updateStatus(PHASE, "Sharing service instance '" + serviceInstanceName + "' from '" + region + "' into " + String.join((CharSequence)", ", shareToRegions.stream().map(s -> "'" + s + "'").collect(Collectors.toSet())));
        ServiceInstanceResponse results = this.description.getClient().getServiceInstances().shareServiceInstance(region, serviceInstanceName, shareToRegions);
        task.updateStatus(PHASE, "Finished sharing service instance '" + serviceInstanceName + "'");
        return results;
    }

    @Generated
    public ShareCloudFoundryServiceAtomicOperation(ShareCloudFoundryServiceDescription description) {
        this.description = description;
    }
}

