/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view;

import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.CacheRepository;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryCluster;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.model.Cluster;
import com.netflix.spinnaker.clouddriver.model.ClusterProvider;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class CloudFoundryClusterProvider
implements ClusterProvider {
    private final Cache cacheView;
    private final CacheRepository repository;

    public String getCloudProviderId() {
        return CloudFoundryCloudProvider.ID;
    }

    private static Map<String, Set<CloudFoundryCluster>> distinctGroupByAccount(Collection<CloudFoundryCluster> clusters) {
        return clusters.stream().collect(Collectors.groupingBy(Cluster::getAccountName, Collectors.toSet()));
    }

    public Map<String, Set<CloudFoundryCluster>> getClusters() {
        return CloudFoundryClusterProvider.distinctGroupByAccount(this.repository.findClustersByKeys(this.cacheView.filterIdentifiers(Keys.Namespace.CLUSTERS.getNs(), Keys.getClusterKey("*", "*", "*")), CacheRepository.Detail.FULL));
    }

    public Map<String, Set<CloudFoundryCluster>> getClusterSummaries(String applicationName) {
        return CloudFoundryClusterProvider.distinctGroupByAccount(this.repository.findClustersByKeys(this.cacheView.filterIdentifiers(Keys.Namespace.CLUSTERS.getNs(), Keys.getClusterKey("*", applicationName, "*")), CacheRepository.Detail.NONE));
    }

    public Map<String, Set<CloudFoundryCluster>> getClusterDetails(String applicationName) {
        return CloudFoundryClusterProvider.distinctGroupByAccount(this.repository.findClustersByKeys(this.cacheView.filterIdentifiers(Keys.Namespace.CLUSTERS.getNs(), Keys.getClusterKey("*", applicationName, "*")), CacheRepository.Detail.FULL));
    }

    public Set<CloudFoundryCluster> getClusters(String applicationName, String account) {
        return this.repository.findClustersByKeys(this.cacheView.filterIdentifiers(Keys.Namespace.CLUSTERS.getNs(), Keys.getClusterKey(account, applicationName, "*")), CacheRepository.Detail.FULL);
    }

    @Nullable
    public CloudFoundryCluster getCluster(String applicationName, String account, String clusterName) {
        return this.getCluster(applicationName, account, clusterName, true);
    }

    @Nullable
    public CloudFoundryCluster getCluster(String application, String account, String name, boolean includeDetails) {
        return this.repository.findClusterByKey(Keys.getClusterKey(account, application, name), includeDetails ? CacheRepository.Detail.FULL : CacheRepository.Detail.NAMES_ONLY).orElse(null);
    }

    @Nullable
    public CloudFoundryServerGroup getServerGroup(String account, String region, String name, boolean includeDetails) {
        return this.repository.findServerGroupByKey(Keys.getServerGroupKey(account, name, region), includeDetails ? CacheRepository.Detail.FULL : CacheRepository.Detail.NAMES_ONLY).orElse(null);
    }

    public CloudFoundryServerGroup getServerGroup(String account, String region, String name) {
        return this.getServerGroup(account, region, name, true);
    }

    public boolean supportsMinimalClusters() {
        return true;
    }

    @Generated
    public CloudFoundryClusterProvider(Cache cacheView, CacheRepository repository) {
        this.cacheView = cacheView;
        this.repository = repository;
    }
}

