/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.view;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.spinnaker.cats.cache.Cache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.CacheRepository;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerProvider;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
class CloudFoundryLoadBalancerProvider
implements LoadBalancerProvider<CloudFoundryLoadBalancer> {
    private final Cache cacheView;
    private final CacheRepository repository;

    public String getCloudProvider() {
        return CloudFoundryCloudProvider.ID;
    }

    public List<CloudFoundryLoadBalancerSummary> list() {
        return new ArrayList<CloudFoundryLoadBalancerSummary>(this.summarizeLoadBalancers(this.cacheView.filterIdentifiers(Keys.Namespace.LOAD_BALANCERS.getNs(), Keys.getAllLoadBalancers())).values());
    }

    @Nullable
    public CloudFoundryLoadBalancerSummary get(String name) {
        return null;
    }

    @Nullable
    public List<CloudFoundryLoadBalancerDetail> byAccountAndRegionAndName(String account, String region, String name) {
        return null;
    }

    public Set<CloudFoundryLoadBalancer> getApplicationLoadBalancers(String application) {
        return this.repository.findLoadBalancersByClusterKeys(this.cacheView.filterIdentifiers(Keys.Namespace.CLUSTERS.getNs(), Keys.getClusterKey("*", application, "*")), CacheRepository.Detail.NAMES_ONLY);
    }

    private Map<String, CloudFoundryLoadBalancerSummary> summarizeLoadBalancers(Collection<String> loadBalancerKeys) {
        HashMap<String, CloudFoundryLoadBalancerSummary> summariesByAccount = new HashMap<String, CloudFoundryLoadBalancerSummary>();
        for (CloudFoundryLoadBalancer loadBalancer : this.repository.findLoadBalancersByKeys(loadBalancerKeys, CacheRepository.Detail.FULL)) {
            String account = loadBalancer.getAccount();
            CloudFoundryLoadBalancerSummary summary = summariesByAccount.computeIfAbsent(account, CloudFoundryLoadBalancerSummary::new);
            CloudFoundryLoadBalancerDetail detail = new CloudFoundryLoadBalancerDetail(account, loadBalancer.getName(), loadBalancer.getSpace());
            summary.accounts.computeIfAbsent((String)account, (Function<String, CloudFoundryLoadBalancerAccount>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lcom/netflix/spinnaker/clouddriver/cloudfoundry/provider/view/CloudFoundryLoadBalancerProvider$CloudFoundryLoadBalancerAccount;)()).regions.computeIfAbsent((String)loadBalancer.getSpace().getRegion(), (Function<String, CloudFoundryLoadBalancerAccountRegion>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, <init>(java.lang.String ), (Ljava/lang/String;)Lcom/netflix/spinnaker/clouddriver/cloudfoundry/provider/view/CloudFoundryLoadBalancerProvider$CloudFoundryLoadBalancerAccountRegion;)()).loadBalancers.add(detail);
        }
        return summariesByAccount;
    }

    @Generated
    public CloudFoundryLoadBalancerProvider(Cache cacheView, CacheRepository repository) {
        this.cacheView = cacheView;
        this.repository = repository;
    }

    public static class CloudFoundryLoadBalancerSummary
    implements LoadBalancerProvider.Item {
        private final String name;
        @JsonIgnore
        private final Map<String, CloudFoundryLoadBalancerAccount> accounts = new HashMap<String, CloudFoundryLoadBalancerAccount>();

        public List<CloudFoundryLoadBalancerAccount> getByAccounts() {
            return new ArrayList<CloudFoundryLoadBalancerAccount>(this.accounts.values());
        }

        @Generated
        public CloudFoundryLoadBalancerSummary(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, CloudFoundryLoadBalancerAccount> getAccounts() {
            return this.accounts;
        }
    }

    public static class CloudFoundryLoadBalancerDetail
    implements LoadBalancerProvider.Details {
        private final String account;
        private final String name;
        private final CloudFoundrySpace space;

        public String getType() {
            return "cf";
        }

        @Generated
        public CloudFoundryLoadBalancerDetail(String account, String name, CloudFoundrySpace space) {
            this.account = account;
            this.name = name;
            this.space = space;
        }

        @Generated
        public String getAccount() {
            return this.account;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public CloudFoundrySpace getSpace() {
            return this.space;
        }
    }

    public static class CloudFoundryLoadBalancerAccount
    implements LoadBalancerProvider.ByAccount {
        private final String name;
        @JsonIgnore
        private final Map<String, CloudFoundryLoadBalancerAccountRegion> regions = new HashMap<String, CloudFoundryLoadBalancerAccountRegion>();

        @JsonProperty(value="regions")
        public List<CloudFoundryLoadBalancerAccountRegion> getByRegions() {
            return new ArrayList<CloudFoundryLoadBalancerAccountRegion>(this.regions.values());
        }

        @Generated
        public CloudFoundryLoadBalancerAccount(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Map<String, CloudFoundryLoadBalancerAccountRegion> getRegions() {
            return this.regions;
        }
    }

    public static class CloudFoundryLoadBalancerAccountRegion
    implements LoadBalancerProvider.ByRegion {
        private final String name;
        private final List<CloudFoundryLoadBalancerDetail> loadBalancers = new ArrayList<CloudFoundryLoadBalancerDetail>();

        @Generated
        public CloudFoundryLoadBalancerAccountRegion(String name) {
            this.name = name;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<CloudFoundryLoadBalancerDetail> getLoadBalancers() {
            return this.loadBalancers;
        }
    }
}

