/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.ResourceNotFoundException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.api.OrganizationService;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryOrganization;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Organizations {
    private final OrganizationService api;
    private final LoadingCache<String, CloudFoundryOrganization> organizationCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, CloudFoundryOrganization>(){

        public CloudFoundryOrganization load(@Nonnull String guid) throws CloudFoundryApiException, ResourceNotFoundException {
            return CloudFoundryClientUtils.safelyCall(() -> Organizations.this.api.findById(guid)).map(org -> CloudFoundryOrganization.builder().id(org.getGuid()).name(org.getName()).build()).orElseThrow(ResourceNotFoundException::new);
        }
    });

    @Nullable
    public CloudFoundryOrganization findById(String orgId) throws CloudFoundryApiException {
        try {
            return (CloudFoundryOrganization)this.organizationCache.get((Object)orgId);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof ResourceNotFoundException) {
                return null;
            }
            throw new CloudFoundryApiException(e.getCause(), "Unable to find organization by id");
        }
    }

    public Optional<CloudFoundryOrganization> findByName(String orgName) throws CloudFoundryApiException {
        return CloudFoundryClientUtils.collectPages("organizations", page -> this.api.all((Integer)page, orgName)).stream().findAny().map(org -> CloudFoundryOrganization.builder().id(org.getGuid()).name(org.getName()).build());
    }

    public List<CloudFoundryOrganization> findAllByNames(List<String> names) {
        if (names == null || names.isEmpty()) {
            throw new IllegalArgumentException("Organization names must not be empty or null");
        }
        return CloudFoundryClientUtils.collectPages("organizations", page -> this.api.all((Integer)page, String.join((CharSequence)",", names))).stream().map(org -> CloudFoundryOrganization.builder().id(org.getGuid()).name(org.getName()).build()).collect(Collectors.toList());
    }

    @Generated
    public Organizations(OrganizationService api) {
        this.api = api;
    }
}

