/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClientUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.Resource;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeleteCloudFoundryServiceBindingDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class DeleteCloudFoundryServiceBindingAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "DELETE_SERVICE_BINDINGS";
    private final DeleteCloudFoundryServiceBindingDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List<Void> priorOutputs) {
        List unbindingServiceInstanceNames = this.description.getServiceUnbindingRequests().stream().map(DeleteCloudFoundryServiceBindingDescription.ServiceUnbindingRequest::getServiceInstanceName).collect(Collectors.toList());
        List<String> unbindingServiceBindingNames = unbindingServiceInstanceNames.stream().map(CloudFoundryClientUtils::convertToValidServiceBindingName).collect(Collectors.toList());
        DeleteCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Unbinding Cloud Foundry application '" + this.description.getServerGroupName() + "' from services: " + String.valueOf(unbindingServiceInstanceNames));
        List<Resource<ServiceBinding>> bindings = this.description.getClient().getApplications().getServiceBindingsByApp(this.description.getServerGroupId());
        this.removeBindings(bindings, unbindingServiceBindingNames);
        DeleteCloudFoundryServiceBindingAtomicOperation.getTask().updateStatus(PHASE, "Successfully unbound Cloud Foundry application '" + this.description.getServerGroupName() + "' from services: " + String.valueOf(unbindingServiceInstanceNames));
        return null;
    }

    private void removeBindings(List<Resource<ServiceBinding>> bindings, List<String> unbindingServiceBindingNames) {
        bindings.stream().filter(b -> unbindingServiceBindingNames.contains(((ServiceBinding)b.getEntity()).getName())).forEach(b -> this.description.getClient().getServiceInstances().deleteServiceBinding(b.getMetadata().getGuid()));
    }

    @Generated
    public DeleteCloudFoundryServiceBindingAtomicOperation(DeleteCloudFoundryServiceBindingDescription description) {
        this.description = description;
    }
}

