/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.artifacts.config.ArtifactCredentials;
import com.netflix.spinnaker.clouddriver.artifacts.maven.MavenArtifactCredentials;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.AbstractServiceInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.CreateServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.CreatePackage;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Lifecycle;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.Process;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessRequest;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.CloudFoundryServerGroupNameResolver;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DeployCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.AbstractCloudFoundryLoadBalancerMappingOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CloudFoundryOperationUtils;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryOrganization;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.ServerGroupMetaDataEnvVar;
import com.netflix.spinnaker.clouddriver.deploy.DeploymentResult;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import com.netflix.spinnaker.kork.artifacts.model.Artifact;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DeployCloudFoundryServerGroupAtomicOperation
extends AbstractCloudFoundryLoadBalancerMappingOperation
implements AtomicOperation<DeploymentResult> {
    private static final String PHASE = "DEPLOY";
    private final OperationPoller operationPoller;
    private final DeployCloudFoundryServerGroupDescription description;

    @Override
    protected String getPhase() {
        return PHASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentResult operate(List priorOutputs) {
        String packageId;
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Deploying '" + this.description.getApplication() + "'");
        CloudFoundryClient client = this.description.getClient();
        CloudFoundryServerGroupNameResolver serverGroupNameResolver = new CloudFoundryServerGroupNameResolver(client, this.description.getSpace());
        this.description.setServerGroupName(serverGroupNameResolver.resolveNextServerGroupName(this.description.getApplication(), this.description.getStack(), this.description.getFreeFormDetails(), false));
        CloudFoundryServerGroup serverGroup = DeployCloudFoundryServerGroupAtomicOperation.createApplication(this.description);
        File packageArtifact = this.description.getDocker() == null ? this.downloadPackageArtifact(this.description) : null;
        try {
            packageId = this.buildPackage(serverGroup.getId(), this.description, packageArtifact);
        }
        finally {
            if (packageArtifact != null) {
                packageArtifact.delete();
            }
        }
        this.createServiceBindings(serverGroup, this.description);
        this.buildDroplet(packageId, serverGroup.getId(), this.description);
        this.updateProcess(serverGroup.getId(), this.description);
        this.scaleApplication(serverGroup.getId(), this.description);
        if (!this.mapRoutes(this.description, this.description.getApplicationAttributes().getRoutes(), this.description.getSpace(), serverGroup.getId())) {
            return this.deploymentResult();
        }
        int desiredInstanceCount = this.description.getApplicationAttributes().getInstances();
        if (this.description.isStartApplication() && desiredInstanceCount > 0) {
            client.getApplications().startApplication(serverGroup.getId());
            ProcessStats.State state = (ProcessStats.State)((Object)this.operationPoller.waitForOperation(() -> client.getApplications().getAppState(serverGroup.getId()), inProgressState -> inProgressState == ProcessStats.State.RUNNING || inProgressState == ProcessStats.State.CRASHED, null, DeployCloudFoundryServerGroupAtomicOperation.getTask(), this.description.getServerGroupName(), PHASE));
            if (state != ProcessStats.State.RUNNING) {
                throw new CloudFoundryApiException(new String[]{"Failed to start '" + this.description.getServerGroupName() + "' which instead " + CloudFoundryOperationUtils.describeProcessState(state)});
            }
        } else {
            DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Stop state requested for '" + this.description.getServerGroupName());
        }
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Deployed '" + this.description.getApplication() + "'");
        return this.deploymentResult();
    }

    private void createServiceBindings(CloudFoundryServerGroup serverGroup, DeployCloudFoundryServerGroupDescription description) {
        List<String> serviceNames = description.getApplicationAttributes().getServices();
        if (serviceNames == null || serviceNames.isEmpty()) {
            return;
        }
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Creating Cloud Foundry service bindings between application '" + description.getServerGroupName() + "' and services: " + String.valueOf(description.getApplicationAttributes().getServices()));
        HashMap serviceInstanceGuids = new HashMap();
        description.getClient().getServiceInstances().findAllServicesBySpaceAndNames(serverGroup.getSpace(), serviceNames).forEach(s -> serviceInstanceGuids.put(((AbstractServiceInstance)s.getEntity()).getName(), s.getMetadata().getGuid()));
        List<CreateServiceBinding> bindings = serviceNames.stream().map(name -> {
            String serviceGuid = (String)serviceInstanceGuids.get(name);
            if (serviceGuid == null || serviceGuid.isEmpty()) {
                DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Failed to create Cloud Foundry service bindings between application '" + description.getServerGroupName() + "' and services: " + String.valueOf(serviceNames));
                throw new CloudFoundryApiException(new String[]{"Unable to find service with the name: '" + name + "' in " + String.valueOf(serverGroup.getSpace())});
            }
            return new CreateServiceBinding(serviceGuid, serverGroup.getId(), (String)name, Collections.emptyMap());
        }).collect(Collectors.toList());
        bindings.forEach(b -> description.getClient().getServiceInstances().createServiceBinding((CreateServiceBinding)b));
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Created Cloud Foundry service bindings between application '" + description.getServerGroupName() + "' and services: " + String.valueOf(description.getApplicationAttributes().getServices()));
    }

    private DeploymentResult deploymentResult() {
        DeploymentResult deploymentResult = new DeploymentResult();
        deploymentResult.setServerGroupNames(Collections.singletonList(this.description.getRegion() + ":" + this.description.getServerGroupName()));
        deploymentResult.getServerGroupNameByRegion().put(this.description.getRegion(), this.description.getServerGroupName());
        deploymentResult.setMessages(DeployCloudFoundryServerGroupAtomicOperation.getTask().getHistory().stream().map(hist -> hist.getPhase() + ":" + hist.getStatus()).collect(Collectors.toList()));
        List<String> routes = this.description.getApplicationAttributes().getRoutes();
        if (routes == null) {
            routes = Collections.emptyList();
        }
        Integer desiredInstanceCount = this.description.getApplicationAttributes().getInstances();
        DeploymentResult.Deployment deployment = new DeploymentResult.Deployment();
        deployment.setCloudProvider(CloudFoundryCloudProvider.ID);
        deployment.setAccount(this.description.getAccountName());
        deployment.setServerGroupName(this.description.getServerGroupName());
        DeploymentResult.Deployment.Capacity capacity = new DeploymentResult.Deployment.Capacity();
        capacity.setDesired(desiredInstanceCount);
        deployment.setCapacity(capacity);
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("env", this.description.getApplicationAttributes().getEnv());
        metadata.put("routes", routes);
        deployment.setMetadata(metadata);
        if (!routes.isEmpty()) {
            deployment.setLocation(routes.get(0));
        }
        deploymentResult.setDeployments(Collections.singleton(deployment));
        return deploymentResult;
    }

    private static CloudFoundryServerGroup createApplication(DeployCloudFoundryServerGroupDescription description) {
        CloudFoundryClient client = description.getClient();
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Creating Cloud Foundry application '" + description.getServerGroupName() + "'");
        Lifecycle lifecycle = description.getDocker() == null ? new Lifecycle(Lifecycle.Type.BUILDPACK, description.getApplicationAttributes()) : new Lifecycle(Lifecycle.Type.DOCKER, description.getApplicationAttributes());
        CloudFoundryServerGroup serverGroup = client.getApplications().createApplication(description.getServerGroupName(), description.getSpace(), DeployCloudFoundryServerGroupAtomicOperation.getEnvironmentVars(description), lifecycle);
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Created Cloud Foundry application '" + description.getServerGroupName() + "'");
        return serverGroup;
    }

    private static Map<String, String> getEnvironmentVars(DeployCloudFoundryServerGroupDescription description) {
        Map environmentVars = Optional.ofNullable(description.getApplicationAttributes().getEnv()).map(HashMap::new).orElse(new HashMap());
        Artifact applicationArtifact = description.getApplicationArtifact();
        if ("cloudfoundry/app".equals(applicationArtifact.getType())) {
            CloudFoundryClient client = description.getClient();
            CloudFoundrySpace orgAndSpaceName = CloudFoundrySpace.fromRegion(applicationArtifact.getLocation());
            Optional<CloudFoundryOrganization> orgOptional = client.getOrganizations().findByName(orgAndSpaceName.getOrganization().getName());
            orgOptional.ifPresent(org -> {
                CloudFoundryServerGroup serverGroup;
                CloudFoundrySpace space = client.getSpaces().findByName(org.getId(), orgAndSpaceName.getName());
                if (space != null && (serverGroup = client.getApplications().findServerGroupByNameAndSpaceId(applicationArtifact.getName(), space.getId())) != null) {
                    serverGroup.getEnv().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("__SPINNAKER_")).forEach(i -> environmentVars.put((String)i.getKey(), i.getValue().toString()));
                }
            });
        }
        ExternalReference artifactInfo = DeployCloudFoundryServerGroupAtomicOperation.resolveArtifactInfo(description);
        artifactInfo.getName().map(name -> environmentVars.put(ServerGroupMetaDataEnvVar.ArtifactName.envVarName, name));
        artifactInfo.getNumber().map(number -> environmentVars.put(ServerGroupMetaDataEnvVar.ArtifactVersion.envVarName, number));
        artifactInfo.getUrl().map(url -> environmentVars.put(ServerGroupMetaDataEnvVar.ArtifactUrl.envVarName, url));
        ExternalReference buildInfo = DeployCloudFoundryServerGroupAtomicOperation.resolveBuildInfo(description);
        buildInfo.getName().map(name -> environmentVars.put(ServerGroupMetaDataEnvVar.JobName.envVarName, name));
        buildInfo.getNumber().map(number -> environmentVars.put(ServerGroupMetaDataEnvVar.JobNumber.envVarName, number));
        buildInfo.getUrl().map(url -> environmentVars.put(ServerGroupMetaDataEnvVar.JobUrl.envVarName, url));
        Optional.ofNullable(description.getExecutionId()).ifPresent(executionId -> environmentVars.put(ServerGroupMetaDataEnvVar.PipelineId.envVarName, executionId));
        return environmentVars;
    }

    private static ExternalReference resolveArtifactInfo(DeployCloudFoundryServerGroupDescription description) {
        return Optional.ofNullable(description.getApplicationArtifact()).map(applicationArtifact -> {
            ExternalReference.ExternalReferenceBuilder artifactInfo = ExternalReference.builder();
            if (MavenArtifactCredentials.TYPES.contains((Object)applicationArtifact.getType())) {
                ArtifactCredentials artifactCredentials = description.getArtifactCredentials();
                artifactInfo.name(artifactCredentials.resolveArtifactName(applicationArtifact)).number(artifactCredentials.resolveArtifactVersion(applicationArtifact)).url(Optional.ofNullable(applicationArtifact.getLocation()));
            }
            return artifactInfo.build();
        }).orElseGet(() -> ExternalReference.builder().build());
    }

    private static ExternalReference resolveBuildInfo(DeployCloudFoundryServerGroupDescription description) {
        Map triggerBuildInfo;
        String triggerType;
        Map<String, Object> trigger;
        Map buildInfo = null;
        Artifact applicationArtifact = description.getApplicationArtifact();
        if (applicationArtifact != null) {
            buildInfo = (Map)applicationArtifact.getMetadata("build");
        }
        if (buildInfo == null && (trigger = description.getTrigger()) != null && ((triggerType = (String)trigger.get("type")).equals("jenkins") || triggerType.equals("manual")) && (triggerBuildInfo = (Map)trigger.get("buildInfo")) != null) {
            buildInfo = triggerBuildInfo;
        }
        return Optional.ofNullable(buildInfo).map(buildInfoMap -> ExternalReference.builder().name(Optional.ofNullable(buildInfoMap.get("name")).map(Object::toString)).number(Optional.ofNullable(buildInfoMap.get("number")).map(Object::toString)).url(Optional.ofNullable(buildInfoMap.get("url")).map(Object::toString)).build()).orElse(ExternalReference.builder().build());
    }

    @NotNull
    private File downloadPackageArtifact(DeployCloudFoundryServerGroupDescription description) {
        File file = null;
        try {
            file = File.createTempFile(UUID.randomUUID().toString(), null);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        try (InputStream artifactInputStream = description.getArtifactCredentials().download(description.getApplicationArtifact());
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            IOUtils.copy((InputStream)artifactInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return file;
    }

    private String buildPackage(String serverGroupId, DeployCloudFoundryServerGroupDescription description, File packageArtifact) {
        String packageId;
        CloudFoundryClient client = description.getClient();
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Creating package for application '" + description.getServerGroupName() + "'");
        if (packageArtifact != null) {
            packageId = client.getApplications().createPackage(new CreatePackage(serverGroupId, CreatePackage.Type.BITS, null));
            client.getApplications().uploadPackageBits(packageId, packageArtifact);
        } else {
            packageId = client.getApplications().createPackage(new CreatePackage(serverGroupId, CreatePackage.Type.DOCKER, description.getDocker()));
        }
        this.operationPoller.waitForOperation(() -> client.getApplications().packageUploadComplete(packageId), Function.identity(), null, DeployCloudFoundryServerGroupAtomicOperation.getTask(), description.getServerGroupName(), PHASE);
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Completed creating package for application '" + description.getServerGroupName() + "'");
        return packageId;
    }

    private void buildDroplet(String packageId, String serverGroupId, DeployCloudFoundryServerGroupDescription description) {
        CloudFoundryClient client = description.getClient();
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Building droplet for package '" + packageId + "'");
        Integer memoryAmount = DeployCloudFoundryServerGroupAtomicOperation.convertToMb("memory", description.getApplicationAttributes().getMemory());
        Integer diskSizeAmount = DeployCloudFoundryServerGroupAtomicOperation.convertToMb("disk quota", description.getApplicationAttributes().getDiskQuota());
        String buildId = client.getApplications().createBuild(packageId, memoryAmount, diskSizeAmount);
        this.operationPoller.waitForOperation(() -> client.getApplications().buildCompleted(buildId), Function.identity(), null, DeployCloudFoundryServerGroupAtomicOperation.getTask(), description.getServerGroupName(), PHASE);
        String dropletGuid = client.getApplications().findDropletGuidFromBuildId(buildId);
        client.getApplications().setCurrentDroplet(serverGroupId, dropletGuid);
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Droplet built for package '" + packageId + "'");
    }

    private void scaleApplication(String serverGroupId, DeployCloudFoundryServerGroupDescription description) {
        CloudFoundryClient client = description.getClient();
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Scaling application '" + description.getServerGroupName() + "'");
        Integer memoryAmount = DeployCloudFoundryServerGroupAtomicOperation.convertToMb("memory", description.getApplicationAttributes().getMemory());
        Integer diskSizeAmount = DeployCloudFoundryServerGroupAtomicOperation.convertToMb("disk quota", description.getApplicationAttributes().getDiskQuota());
        client.getProcesses().scaleProcess(serverGroupId, description.getApplicationAttributes().getInstances(), memoryAmount, diskSizeAmount);
        if (!description.getApplicationAttributes().getProcesses().isEmpty()) {
            List<Process> processes = client.getProcesses().getAllProcessesByAppId(serverGroupId);
            for (ProcessRequest req : description.getApplicationAttributes().getProcesses()) {
                String processGuid = this.getProcessGuidByType(processes, req.getType());
                Integer pMemoryAmount = DeployCloudFoundryServerGroupAtomicOperation.convertToMb("memory", req.getMemory());
                Integer pDiskSizeAmount = DeployCloudFoundryServerGroupAtomicOperation.convertToMb("disk quota", req.getDiskQuota());
                client.getProcesses().scaleProcess(processGuid, req.getInstances(), pMemoryAmount, pDiskSizeAmount);
            }
        }
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Scaled application '" + description.getServerGroupName() + "'");
    }

    private void updateProcess(String serverGroupId, DeployCloudFoundryServerGroupDescription description) {
        CloudFoundryClient client = description.getClient();
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Updating process '" + description.getServerGroupName() + "'");
        client.getProcesses().updateProcess(serverGroupId, description.getApplicationAttributes().getCommand(), description.getApplicationAttributes().getHealthCheckType(), description.getApplicationAttributes().getHealthCheckHttpEndpoint(), description.getApplicationAttributes().getTimeout(), null);
        if (!description.getApplicationAttributes().getProcesses().isEmpty()) {
            List<Process> processes = client.getProcesses().getAllProcessesByAppId(serverGroupId);
            for (ProcessRequest req : description.getApplicationAttributes().getProcesses()) {
                String processGuid = this.getProcessGuidByType(processes, req.getType());
                client.getProcesses().updateProcess(processGuid, req.getCommand(), req.getHealthCheckType(), req.getHealthCheckHttpEndpoint(), req.getTimeout(), req.getHealthCheckInvocationTimeout());
            }
        }
        DeployCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Updated process '" + description.getServerGroupName() + "'");
    }

    @Nullable
    static Integer convertToMb(String field, @Nullable String size) {
        String value;
        if (size == null) {
            return null;
        }
        if (StringUtils.isNumeric((CharSequence)size)) {
            return Integer.parseInt(size);
        }
        if ((size = size.toLowerCase()).endsWith("g") || size.endsWith("gb")) {
            String value2 = size.substring(0, size.indexOf(103));
            if (StringUtils.isNumeric((CharSequence)value2)) {
                return Integer.parseInt(value2) * 1024;
            }
        } else if ((size.endsWith("m") || size.endsWith("mb")) && StringUtils.isNumeric((CharSequence)(value = size.substring(0, size.indexOf(109))))) {
            return Integer.parseInt(value);
        }
        throw new IllegalArgumentException(String.format("Invalid size for application %s = '%s'", field, size));
    }

    private String getProcessGuidByType(List<Process> processes, String type) {
        return processes.stream().filter(p -> p.getType().equalsIgnoreCase(type)).map(Process::getGuid).findFirst().orElseThrow(() -> new CloudFoundryApiException(new String[]{"Unable to find a process with type: " + type}));
    }

    @Generated
    public DeployCloudFoundryServerGroupAtomicOperation(OperationPoller operationPoller, DeployCloudFoundryServerGroupDescription description) {
        this.operationPoller = operationPoller;
        this.description = description;
    }

    private static class ExternalReference {
        private Optional<String> name;
        private Optional<String> number;
        private Optional<String> url;

        @Generated
        private static Optional<String> $default$name() {
            return Optional.empty();
        }

        @Generated
        private static Optional<String> $default$number() {
            return Optional.empty();
        }

        @Generated
        private static Optional<String> $default$url() {
            return Optional.empty();
        }

        @Generated
        ExternalReference(Optional<String> name, Optional<String> number, Optional<String> url) {
            this.name = name;
            this.number = number;
            this.url = url;
        }

        @Generated
        public static ExternalReferenceBuilder builder() {
            return new ExternalReferenceBuilder();
        }

        @Generated
        public Optional<String> getName() {
            return this.name;
        }

        @Generated
        public Optional<String> getNumber() {
            return this.number;
        }

        @Generated
        public Optional<String> getUrl() {
            return this.url;
        }

        @Generated
        public ExternalReference setName(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Generated
        public ExternalReference setNumber(Optional<String> number) {
            this.number = number;
            return this;
        }

        @Generated
        public ExternalReference setUrl(Optional<String> url) {
            this.url = url;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalReference)) {
                return false;
            }
            ExternalReference other = (ExternalReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Optional<String> this$name = this.getName();
            Optional<String> other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            Optional<String> this$number = this.getNumber();
            Optional<String> other$number = other.getNumber();
            if (this$number == null ? other$number != null : !((Object)this$number).equals(other$number)) {
                return false;
            }
            Optional<String> this$url = this.getUrl();
            Optional<String> other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !((Object)this$url).equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExternalReference;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Optional<String> $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            Optional<String> $number = this.getNumber();
            result = result * 59 + ($number == null ? 43 : ((Object)$number).hashCode());
            Optional<String> $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : ((Object)$url).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DeployCloudFoundryServerGroupAtomicOperation.ExternalReference(name=" + String.valueOf(this.getName()) + ", number=" + String.valueOf(this.getNumber()) + ", url=" + String.valueOf(this.getUrl()) + ")";
        }

        @Generated
        public static class ExternalReferenceBuilder {
            @Generated
            private boolean name$set;
            @Generated
            private Optional<String> name$value;
            @Generated
            private boolean number$set;
            @Generated
            private Optional<String> number$value;
            @Generated
            private boolean url$set;
            @Generated
            private Optional<String> url$value;

            @Generated
            ExternalReferenceBuilder() {
            }

            @Generated
            public ExternalReferenceBuilder name(Optional<String> name) {
                this.name$value = name;
                this.name$set = true;
                return this;
            }

            @Generated
            public ExternalReferenceBuilder number(Optional<String> number) {
                this.number$value = number;
                this.number$set = true;
                return this;
            }

            @Generated
            public ExternalReferenceBuilder url(Optional<String> url) {
                this.url$value = url;
                this.url$set = true;
                return this;
            }

            @Generated
            public ExternalReference build() {
                Optional<String> name$value = this.name$value;
                if (!this.name$set) {
                    name$value = ExternalReference.$default$name();
                }
                Optional<String> number$value = this.number$value;
                if (!this.number$set) {
                    number$value = ExternalReference.$default$number();
                }
                Optional<String> url$value = this.url$value;
                if (!this.url$set) {
                    url$value = ExternalReference.$default$url();
                }
                return new ExternalReference(name$value, number$value, url$value);
            }

            @Generated
            public String toString() {
                return "DeployCloudFoundryServerGroupAtomicOperation.ExternalReference.ExternalReferenceBuilder(name$value=" + String.valueOf(this.name$value) + ", number$value=" + String.valueOf(this.number$value) + ", url$value=" + String.valueOf(this.url$value) + ")";
            }
        }
    }
}

