/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.ServiceInstanceResponse;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.LastOperation;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v2.ServiceBinding;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.DestroyCloudFoundryServiceDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class DestroyCloudFoundryServiceAtomicOperation
implements AtomicOperation<ServiceInstanceResponse> {
    private static final String PHASE = "DELETE_SERVICE";
    private final DestroyCloudFoundryServiceDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public ServiceInstanceResponse operate(List priorOutputs) {
        Task task = DestroyCloudFoundryServiceAtomicOperation.getTask();
        if (this.description.isRemoveBindings()) {
            task.updateStatus(PHASE, "Started removing service bindings for '" + this.description.getServiceInstanceName() + "' from space " + this.description.getSpace().getName());
            HashMap map = new HashMap();
            this.description.getClient().getServiceInstances().findAllServiceBindingsByServiceName(this.description.getRegion(), this.description.getServiceInstanceName()).stream().forEach(r -> map.put(r.getMetadata().getGuid(), (ServiceBinding)r.getEntity()));
            for (ServiceBinding sb : map.values()) {
                CloudFoundryServerGroup sg = this.description.getClient().getApplications().findById(sb.getAppGuid());
                String appName = this.description.getApplications().stream().findFirst().get();
                if (!sg.getMoniker().getApp().equals(appName)) {
                    throw new IllegalArgumentException("Unable to unbind server group '" + sg.getName() + "' from '" + this.description.getServiceInstanceName() + "' because it doesn't belong to the application '" + appName + "'");
                }
                task.updateStatus(PHASE, "Finished removing service bindings for '" + this.description.getServiceInstanceName() + "' from space " + this.description.getSpace().getName());
            }
            for (String sbKey : map.keySet()) {
                this.description.getClient().getServiceInstances().deleteServiceBinding(sbKey);
            }
        }
        ServiceInstanceResponse response = this.description.getClient().getServiceInstances().destroyServiceInstance(this.description.getSpace(), this.description.getServiceInstanceName());
        task.updateStatus(PHASE, "Started removing service instance '" + this.description.getServiceInstanceName() + "' from space " + this.description.getSpace().getName());
        LastOperation.State state = response.getState();
        if (state == LastOperation.State.NOT_FOUND) {
            throw new RuntimeException("Service instance " + this.description.getServiceInstanceName() + " not found, in " + this.description.getSpace().getRegion());
        }
        return response;
    }

    @Generated
    public DestroyCloudFoundryServiceAtomicOperation(DestroyCloudFoundryServiceDescription description) {
        this.description = description;
    }
}

