/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.v3.ProcessStats;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.StopCloudFoundryServerGroupDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops.CloudFoundryOperationUtils;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.helpers.OperationPoller;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class StopCloudFoundryServerGroupAtomicOperation
implements AtomicOperation<Void> {
    private static final String PHASE = "STOP_SERVER_GROUP";
    private final OperationPoller operationPoller;
    private final StopCloudFoundryServerGroupDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        StopCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Stopping '" + this.description.getServerGroupName() + "'");
        CloudFoundryClient client = this.description.getClient();
        client.getApplications().stopApplication(this.description.getServerGroupId());
        ProcessStats.State state = (ProcessStats.State)((Object)this.operationPoller.waitForOperation(() -> client.getApplications().getAppState(this.description.getServerGroupId()), inProgressState -> inProgressState != ProcessStats.State.STARTING && inProgressState != ProcessStats.State.RUNNING && inProgressState != ProcessStats.State.STOPPING, null, StopCloudFoundryServerGroupAtomicOperation.getTask(), this.description.getServerGroupName(), PHASE));
        if (state != ProcessStats.State.DOWN) {
            throw new CloudFoundryApiException(new String[]{"Failed to stop '" + this.description.getServerGroupName() + "' which instead " + CloudFoundryOperationUtils.describeProcessState(state)});
        }
        StopCloudFoundryServerGroupAtomicOperation.getTask().updateStatus(PHASE, "Stopped '" + this.description.getServerGroupName() + "'");
        return null;
    }

    @Generated
    public StopCloudFoundryServerGroupAtomicOperation(OperationPoller operationPoller, StopCloudFoundryServerGroupDescription description) {
        this.operationPoller = operationPoller;
        this.description = description;
    }
}

