/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.Routes;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.LoadBalancersDescription;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class UnmapLoadBalancersAtomicOperation
implements AtomicOperation<Void> {
    public static final String PHASE = "UNMAP_LOAD_BALANCERS";
    private final LoadBalancersDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public Void operate(List priorOutputs) {
        UnmapLoadBalancersAtomicOperation.getTask().updateStatus(PHASE, "Unmapping '" + this.description.getServerGroupName() + "' from load balancer(s).");
        List<String> routeList = this.description.getRoutes();
        if (routeList == null || routeList.size() == 0) {
            throw new CloudFoundryApiException(new String[]{"No load balancer specified"});
        }
        Routes routes = this.description.getClient().getRoutes();
        Map<String, Optional> lbMap = routeList.stream().collect(Collectors.toMap(uri -> uri, uri -> Optional.ofNullable(routes.find(routes.toRouteId((String)uri), this.description.getSpace().getId()))));
        routeList.forEach(uri -> {
            if (!Routes.isValidRouteFormat(uri)) {
                throw new CloudFoundryApiException(new String[]{"Invalid format for load balancer '" + uri + "'"});
            }
            if (!((Optional)lbMap.get(uri)).isPresent()) {
                throw new CloudFoundryApiException(new String[]{"Load balancer '" + uri + "' does not exist"});
            }
        });
        CloudFoundryClient client = this.description.getClient();
        lbMap.forEach((uri, o) -> {
            UnmapLoadBalancersAtomicOperation.getTask().updateStatus(PHASE, "Unmapping load balancer '" + uri + "'");
            o.ifPresent(lb -> client.getApplications().unmapRoute(this.description.getServerGroupId(), lb.getId()));
            UnmapLoadBalancersAtomicOperation.getTask().updateStatus(PHASE, "Unmapped load balancer '" + uri + "'");
        });
        return null;
    }

    @Generated
    public UnmapLoadBalancersAtomicOperation(LoadBalancersDescription description) {
        this.description = description;
    }
}

