/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.ops;

import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryApiException;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.CloudFoundryClient;
import com.netflix.spinnaker.clouddriver.cloudfoundry.client.model.RouteId;
import com.netflix.spinnaker.clouddriver.cloudfoundry.deploy.description.UpsertCloudFoundryLoadBalancerDescription;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryLoadBalancer;
import com.netflix.spinnaker.clouddriver.data.task.Task;
import com.netflix.spinnaker.clouddriver.data.task.TaskRepository;
import com.netflix.spinnaker.clouddriver.orchestration.AtomicOperation;
import java.util.List;
import lombok.Generated;

public class UpsertCloudFoundryLoadBalancerAtomicOperation
implements AtomicOperation<CloudFoundryLoadBalancer> {
    private static final String PHASE = "UPSERT_LOAD_BALANCER";
    private final UpsertCloudFoundryLoadBalancerDescription description;

    private static Task getTask() {
        return (Task)TaskRepository.threadLocalTask.get();
    }

    public CloudFoundryLoadBalancer operate(List priorOutputs) {
        UpsertCloudFoundryLoadBalancerAtomicOperation.getTask().updateStatus(PHASE, "Creating load balancer in '" + this.description.getRegion() + "'");
        CloudFoundryClient client = this.description.getClient();
        CloudFoundryLoadBalancer loadBalancer = client.getRoutes().createRoute(new RouteId(this.description.getHost(), this.description.getPath(), this.description.getPort(), this.description.getDomain().getId()), this.description.getSpace().getId());
        if (loadBalancer == null) {
            throw new CloudFoundryApiException(new String[]{"Load balancer already exists in another organization and space"});
        }
        UpsertCloudFoundryLoadBalancerAtomicOperation.getTask().updateStatus(PHASE, "Done creating load balancer");
        return loadBalancer;
    }

    @Generated
    public UpsertCloudFoundryLoadBalancerAtomicOperation(UpsertCloudFoundryLoadBalancerDescription description) {
        this.description = description;
    }
}

