/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.netflix.spinnaker.clouddriver.cloudfoundry.CloudFoundryCloudProvider;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryDomain;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryModel;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.Views;
import com.netflix.spinnaker.clouddriver.model.LoadBalancer;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerInstance;
import com.netflix.spinnaker.clouddriver.model.LoadBalancerServerGroup;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonDeserialize(builder=CloudFoundryLoadBalancerBuilder.class)
@JsonIgnoreProperties(value={"mappedApps"})
public final class CloudFoundryLoadBalancer
extends CloudFoundryModel
implements LoadBalancer,
Cloneable {
    private static final Moniker EMPTY_MONIKER = new Moniker();
    @JsonView(value={Views.Cache.class})
    private final String account;
    @JsonView(value={Views.Cache.class})
    private final String id;
    @JsonView(value={Views.Cache.class})
    private final String host;
    @JsonView(value={Views.Cache.class})
    @Nullable
    private final String path;
    @JsonView(value={Views.Cache.class})
    @Nullable
    private final Integer port;
    @JsonView(value={Views.Cache.class})
    private final CloudFoundrySpace space;
    @JsonView(value={Views.Cache.class})
    private final CloudFoundryDomain domain;
    @JsonView(value={Views.Relationship.class})
    private final Set<CloudFoundryServerGroup> mappedApps;

    @JsonProperty
    public String getName() {
        return this.host + "." + this.domain.getName() + (String)(this.port == null ? "" : "-" + this.port) + (StringUtils.isEmpty((CharSequence)this.path) ? "" : this.path);
    }

    public Moniker getMoniker() {
        return EMPTY_MONIKER;
    }

    public Set<LoadBalancerServerGroup> getServerGroups() {
        return this.mappedApps.stream().map(app -> new LoadBalancerServerGroup(app.getName(), this.account, app.getRegion(), Boolean.valueOf(app.getState() == CloudFoundryServerGroup.State.STOPPED), Collections.emptySet(), app.getInstances().stream().map(it -> new LoadBalancerInstance(it.getId(), it.getName(), null, it.getHealth().get(0))).collect(Collectors.toSet()), CloudFoundryCloudProvider.ID)).collect(Collectors.toSet());
    }

    @Deprecated
    public String getType() {
        return CloudFoundryCloudProvider.ID;
    }

    public String getRegion() {
        return this.space != null ? this.space.getRegion() : null;
    }

    @Generated
    CloudFoundryLoadBalancer(String account, String id, String host, @Nullable String path, @Nullable Integer port, CloudFoundrySpace space, CloudFoundryDomain domain, Set<CloudFoundryServerGroup> mappedApps) {
        this.account = account;
        this.id = id;
        this.host = host;
        this.path = path;
        this.port = port;
        this.space = space;
        this.domain = domain;
        this.mappedApps = mappedApps;
    }

    @Generated
    public static CloudFoundryLoadBalancerBuilder builder() {
        return new CloudFoundryLoadBalancerBuilder();
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Nullable
    @Generated
    public String getPath() {
        return this.path;
    }

    @Nullable
    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public CloudFoundrySpace getSpace() {
        return this.space;
    }

    @Generated
    public CloudFoundryDomain getDomain() {
        return this.domain;
    }

    @Generated
    public Set<CloudFoundryServerGroup> getMappedApps() {
        return this.mappedApps;
    }

    @Generated
    public String toString() {
        return "CloudFoundryLoadBalancer(account=" + this.getAccount() + ", id=" + this.getId() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", port=" + this.getPort() + ", space=" + String.valueOf(this.getSpace()) + ", domain=" + String.valueOf(this.getDomain()) + ", mappedApps=" + String.valueOf(this.getMappedApps()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudFoundryLoadBalancer)) {
            return false;
        }
        CloudFoundryLoadBalancer other = (CloudFoundryLoadBalancer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CloudFoundryLoadBalancer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public CloudFoundryLoadBalancer withMappedApps(Set<CloudFoundryServerGroup> mappedApps) {
        return this.mappedApps == mappedApps ? this : new CloudFoundryLoadBalancer(this.account, this.id, this.host, this.path, this.port, this.space, this.domain, mappedApps);
    }

    @Generated
    public static class CloudFoundryLoadBalancerBuilder {
        @Generated
        private String account;
        @Generated
        private String id;
        @Generated
        private String host;
        @Generated
        private String path;
        @Generated
        private Integer port;
        @Generated
        private CloudFoundrySpace space;
        @Generated
        private CloudFoundryDomain domain;
        @Generated
        private Set<CloudFoundryServerGroup> mappedApps;

        @Generated
        CloudFoundryLoadBalancerBuilder() {
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder account(String account) {
            this.account = account;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder host(String host) {
            this.host = host;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder path(@Nullable String path) {
            this.path = path;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder space(CloudFoundrySpace space) {
            this.space = space;
            return this;
        }

        @JsonView(value={Views.Cache.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder domain(CloudFoundryDomain domain) {
            this.domain = domain;
            return this;
        }

        @JsonView(value={Views.Relationship.class})
        @Generated
        public CloudFoundryLoadBalancerBuilder mappedApps(Set<CloudFoundryServerGroup> mappedApps) {
            this.mappedApps = mappedApps;
            return this;
        }

        @Generated
        public CloudFoundryLoadBalancer build() {
            return new CloudFoundryLoadBalancer(this.account, this.id, this.host, this.path, this.port, this.space, this.domain, this.mappedApps);
        }

        @Generated
        public String toString() {
            return "CloudFoundryLoadBalancer.CloudFoundryLoadBalancerBuilder(account=" + this.account + ", id=" + this.id + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", space=" + String.valueOf(this.space) + ", domain=" + String.valueOf(this.domain) + ", mappedApps=" + String.valueOf(this.mappedApps) + ")";
        }
    }
}

