/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.netflix.frigga.Names;
import com.netflix.spectator.api.Registry;
import com.netflix.spinnaker.cats.agent.AgentDataType;
import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.agent.DefaultCacheResult;
import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.DefaultCacheData;
import com.netflix.spinnaker.cats.cache.RelationshipCacheFilter;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandAgent;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.Keys;
import com.netflix.spinnaker.clouddriver.cloudfoundry.cache.ResourceCacheData;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryApplication;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryCluster;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryInstance;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundryServerGroup;
import com.netflix.spinnaker.clouddriver.cloudfoundry.model.CloudFoundrySpace;
import com.netflix.spinnaker.clouddriver.cloudfoundry.provider.agent.AbstractCloudFoundryCachingAgent;
import com.netflix.spinnaker.clouddriver.cloudfoundry.security.CloudFoundryCredentials;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudFoundryServerGroupCachingAgent
extends AbstractCloudFoundryCachingAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CloudFoundryServerGroupCachingAgent.class);
    private static final ObjectMapper cacheViewMapper = new ObjectMapper().disable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
    private final Collection<AgentDataType> providedDataTypes = Arrays.asList(AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.APPLICATIONS.getNs()), AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.CLUSTERS.getNs()), AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.SERVER_GROUPS.getNs()), AgentDataType.Authority.AUTHORITATIVE.forType(Keys.Namespace.INSTANCES.getNs()));

    public CloudFoundryServerGroupCachingAgent(CloudFoundryCredentials cloudFoundryCredentials, Registry registry) {
        super(cloudFoundryCredentials, registry);
    }

    public CacheResult loadData(ProviderCache providerCache) {
        long loadDataStart = this.getInternalClock().millis();
        String accountName = this.getAccountName();
        log.info("Caching all resources in Cloud Foundry account " + accountName);
        List<String> spaceFilters = this.getCredentials().getFilteredSpaces().stream().map(s -> s.getId()).collect(Collectors.toList());
        List<CloudFoundryApplication> apps = this.getClient().getApplications().all(spaceFilters);
        List clusters = apps.stream().flatMap(app -> app.getClusters().stream()).collect(Collectors.toList());
        List serverGroups = clusters.stream().flatMap(cluster -> cluster.getServerGroups().stream()).collect(Collectors.toList());
        List instances = serverGroups.stream().flatMap(serverGroup -> serverGroup.getInstances().stream()).collect(Collectors.toList());
        Collection onDemandCacheData = providerCache.getAll(Keys.Namespace.ON_DEMAND.getNs(), providerCache.filterIdentifiers(Keys.Namespace.ON_DEMAND.getNs(), Keys.getServerGroupKey(accountName, "*", "*")));
        ArrayList toEvict = new ArrayList();
        HashMap toKeep = new HashMap();
        onDemandCacheData.forEach(cacheData -> {
            long cacheTime = (Long)cacheData.getAttributes().get("cacheTime");
            if (cacheTime < loadDataStart && (Integer)cacheData.getAttributes().computeIfAbsent("processedCount", s -> 0) > 0) {
                toEvict.add(cacheData.getId());
            } else {
                toKeep.put(cacheData.getId(), cacheData);
            }
        });
        HashMap results = io.vavr.collection.HashMap.empty().toJavaMap();
        results.put(Keys.Namespace.APPLICATIONS.getNs(), (Collection)apps.stream().map(this::buildApplicationCacheData).collect(Collectors.toSet()));
        results.put(Keys.Namespace.CLUSTERS.getNs(), (Collection)clusters.stream().map(this::buildClusterCacheData).collect(Collectors.toSet()));
        results.put(Keys.Namespace.SERVER_GROUPS.getNs(), (Collection)serverGroups.stream().map(sg -> this.setServerGroupCacheData(toKeep, (CloudFoundryServerGroup)sg, loadDataStart)).filter(c -> c != null && c.getId() != null).collect(Collectors.toSet()));
        results.put(Keys.Namespace.INSTANCES.getNs(), (Collection)instances.stream().map(this::buildInstanceCacheData).collect(Collectors.toSet()));
        onDemandCacheData.forEach(this::processOnDemandCacheData);
        results.put(Keys.Namespace.ON_DEMAND.getNs(), toKeep.values());
        log.debug("Cache loaded for Cloud Foundry account {}, ({} sec)", (Object)accountName, (Object)((this.getInternalClock().millis() - loadDataStart) / 1000L));
        return new DefaultCacheResult((Map)results, Collections.singletonMap(Keys.Namespace.ON_DEMAND.getNs(), toEvict));
    }

    public boolean handles(OnDemandType type, String cloudProvider) {
        return type.equals((Object)OnDemandType.ServerGroup) && cloudProvider.equals("cloudfoundry");
    }

    public OnDemandAgent.OnDemandResult handle(ProviderCache providerCache, Map<String, ?> data) {
        Map<String, Collection<Object>> evictions;
        DefaultCacheResult serverGroupCacheResults;
        String account = Optional.ofNullable(data.get("account")).map(Object::toString).orElse(null);
        String region = Optional.ofNullable(data.get("region")).map(Object::toString).orElse(null);
        if (account == null || region == null) {
            return null;
        }
        if (!this.getAccountName().equals(account)) {
            return null;
        }
        CloudFoundrySpace space = this.getClient().getSpaces().findSpaceByRegion(region).orElse(null);
        if (space == null) {
            return null;
        }
        String serverGroupName = Optional.ofNullable(data.get("serverGroupName")).map(Object::toString).orElse(null);
        if (serverGroupName == null) {
            return null;
        }
        log.info("On Demand cache refresh triggered, waiting for Server group loadData to be called");
        CloudFoundryServerGroup cloudFoundryServerGroup = this.getClient().getApplications().findServerGroupByNameAndSpaceId(serverGroupName, space.getId());
        String serverGroupKey = Keys.getServerGroupKey(this.getAccountName(), serverGroupName, region);
        if (cloudFoundryServerGroup != null) {
            Set<CacheData> serverGroupCacheData = Collections.singleton(this.buildServerGroupCacheData(cloudFoundryServerGroup));
            serverGroupCacheResults = new DefaultCacheResult(Collections.singletonMap(Keys.Namespace.SERVER_GROUPS.getNs(), serverGroupCacheData));
            providerCache.putCacheData(Keys.Namespace.ON_DEMAND.getNs(), this.buildOnDemandCacheData(serverGroupKey, serverGroupCacheResults.getCacheResults()));
            evictions = Collections.emptyMap();
        } else {
            serverGroupCacheResults = new DefaultCacheResult(Collections.singletonMap(Keys.Namespace.SERVER_GROUPS.getNs(), Collections.emptyList()));
            evictions = Collections.singletonMap(Keys.Namespace.SERVER_GROUPS.getNs(), providerCache.filterIdentifiers(Keys.Namespace.SERVER_GROUPS.getNs(), serverGroupKey));
        }
        return new OnDemandAgent.OnDemandResult(this.getOnDemandAgentType(), (CacheResult)serverGroupCacheResults, evictions);
    }

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache providerCache) {
        Collection keys = providerCache.filterIdentifiers(Keys.Namespace.ON_DEMAND.getNs(), Keys.getServerGroupKey(this.getAccountName(), "*", "*"));
        return providerCache.getAll(Keys.Namespace.ON_DEMAND.getNs(), keys, (CacheFilter)RelationshipCacheFilter.none()).stream().map(it -> {
            String serverGroupId = it.getId();
            Map details = Keys.parse(serverGroupId).orElse(Collections.emptyMap());
            Map attributes = it.getAttributes();
            return io.vavr.collection.HashMap.of((Object)"id", (Object)serverGroupId, (Object)"details", details, (Object)"moniker", (Object)this.convertOnDemandDetails(Collections.singletonMap("serverGroupName", (String)details.get("serverGroup"))), (Object)"cacheTime", attributes.get("cacheTime"), (Object)"cacheExpiry", attributes.get("cacheExpiry"), (Object)"processedCount", attributes.get("processedCount"), (Object)"processedTime", attributes.get("processedTime")).toJavaMap();
        }).collect(Collectors.toSet());
    }

    public Moniker convertOnDemandDetails(Map<String, String> monikerData) {
        return Optional.ofNullable(monikerData).flatMap(m -> Optional.ofNullable((String)m.get("serverGroupName")).map(serverGroupName -> {
            Names names = Names.parseName((String)serverGroupName);
            return Moniker.builder().app(names.getApp()).stack(names.getStack()).detail(names.getDetail()).cluster(names.getCluster()).sequence(names.getSequence()).build();
        })).orElse(null);
    }

    private CacheData setServerGroupCacheData(Map<String, CacheData> onDemandCacheDataToKeep, CloudFoundryServerGroup serverGroup, long start) {
        String account = this.getAccountName();
        String key = Keys.getServerGroupKey(account, serverGroup.getName(), serverGroup.getRegion());
        CacheData sgCacheData = onDemandCacheDataToKeep.get(key);
        if (sgCacheData != null && (Long)sgCacheData.getAttributes().get("cacheTime") > start) {
            Map<String, Collection<ResourceCacheData>> cacheResults = this.getCacheResultsFromCacheData(sgCacheData);
            onDemandCacheDataToKeep.remove(key);
            return cacheResults.get(Keys.Namespace.SERVER_GROUPS.getNs()).stream().findFirst().orElse(null);
        }
        return this.buildServerGroupCacheData(serverGroup);
    }

    private CacheData buildApplicationCacheData(CloudFoundryApplication app) {
        return new ResourceCacheData(Keys.getApplicationKey(app.getName()), CloudFoundryServerGroupCachingAgent.cacheView(app), Collections.singletonMap(Keys.Namespace.CLUSTERS.getNs(), (Collection)app.getClusters().stream().map(cluster -> Keys.getClusterKey(this.getAccountName(), app.getName(), cluster.getName())).collect(Collectors.toSet())));
    }

    private CacheData buildClusterCacheData(CloudFoundryCluster cluster) {
        String account = this.getAccountName();
        return new ResourceCacheData(Keys.getClusterKey(account, cluster.getMoniker().getApp(), cluster.getName()), CloudFoundryServerGroupCachingAgent.cacheView(cluster), Collections.singletonMap(Keys.Namespace.SERVER_GROUPS.getNs(), (Collection)cluster.getServerGroups().stream().map(sg -> Keys.getServerGroupKey(account, sg.getName(), sg.getRegion())).collect(Collectors.toSet())));
    }

    private CacheData buildServerGroupCacheData(CloudFoundryServerGroup serverGroup) {
        String account = this.getAccountName();
        return new ResourceCacheData(Keys.getServerGroupKey(account, serverGroup.getName(), serverGroup.getRegion()), CloudFoundryServerGroupCachingAgent.cacheView(serverGroup), io.vavr.collection.HashMap.of((Object)Keys.Namespace.INSTANCES.getNs(), (Object)serverGroup.getInstances().stream().map(inst -> Keys.getInstanceKey(account, inst.getName())).collect(Collectors.toSet()), (Object)Keys.Namespace.LOAD_BALANCERS.getNs(), (Object)serverGroup.getLoadBalancers().stream().map(lb -> Keys.getLoadBalancerKey(account, lb, serverGroup.getSpace().getRegion())).collect(Collectors.toSet())).toJavaMap());
    }

    private CacheData buildInstanceCacheData(CloudFoundryInstance instance) {
        return new ResourceCacheData(Keys.getInstanceKey(this.getAccountName(), instance.getName()), CloudFoundryServerGroupCachingAgent.cacheView(instance), Collections.emptyMap());
    }

    @Override
    CacheData buildOnDemandCacheData(String key, Map<String, Collection<CacheData>> cacheResult) {
        try {
            return new DefaultCacheData(key, (int)TimeUnit.MINUTES.toSeconds(10L), (Map)ImmutableMap.of((Object)"cacheTime", (Object)this.getInternalClock().instant().toEpochMilli(), (Object)"cacheResults", (Object)cacheViewMapper.writeValueAsString(cacheResult), (Object)"processedCount", (Object)0), Collections.emptyMap(), this.getInternalClock());
        }
        catch (JsonProcessingException serializationException) {
            throw new RuntimeException("cache results serialization failed", serializationException);
        }
    }

    @Generated
    public Collection<AgentDataType> getProvidedDataTypes() {
        return this.providedDataTypes;
    }
}

