/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.clouddriver.config.CloudConfigRefreshProperties;
import com.netflix.spinnaker.clouddriver.config.ModifiableFilePropertySources;
import com.netflix.spinnaker.clouddriver.refresh.CloudConfigRefreshScheduler;
import com.netflix.spinnaker.kork.configserver.autoconfig.RemoteConfigSourceConfigured;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.EnableConfigServer;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CloudConfigRefreshProperties.class})
public class CloudConfigRefreshConfig {
    @Bean
    @ConditionalOnExpression(value="${dynamic-config.enabled:false}")
    ModifiableFilePropertySources modifiableFilePropertySources(ConfigurableApplicationContext applicationContext, RefreshScope refreshScope, @Value(value="${dynamic-config.files}") List<String> dynamicFiles) {
        return new ModifiableFilePropertySources(applicationContext, refreshScope, dynamicFiles);
    }

    @Configuration
    @Conditional(value={RemoteConfigSourceConfigured.class})
    @EnableConfigServer
    static class RemoteConfigSourceConfiguration {
        RemoteConfigSourceConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="cloud.config", value={"refreshIntervalSeconds"}, matchIfMissing=true)
        public CloudConfigRefreshScheduler cloudConfigIntervalRefreshScheduler(ContextRefresher contextRefresher, CloudConfigRefreshProperties cloudConfigProperties) {
            return new CloudConfigRefreshScheduler(contextRefresher, cloudConfigProperties.getRefreshIntervalSeconds());
        }
    }
}

