/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.wnameless.json.flattener.JsonFlattener;
import com.netflix.spinnaker.clouddriver.config.ConfigurationProvider;
import com.netflix.spinnaker.kork.configserver.CloudConfigResourceService;
import com.netflix.spinnaker.kork.secrets.SecretManager;
import com.netflix.spinnaker.kork.secrets.SecretSession;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.bind.PlaceholdersResolver;
import org.springframework.boot.context.properties.bind.PropertySourcesPlaceholdersResolver;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.MapConfigurationPropertySource;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public abstract class AbstractBootstrapCredentialsConfigurationProvider<T>
implements ConfigurationProvider<T> {
    private final ConfigurableApplicationContext applicationContext;
    private CloudConfigResourceService configResourceService;
    private SecretSession secretSession;
    private Map<String, String> configServerCache;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public AbstractBootstrapCredentialsConfigurationProvider(ConfigurableApplicationContext applicationContext, CloudConfigResourceService configResourceService, SecretManager secretManager) {
        this.applicationContext = applicationContext;
        this.configResourceService = configResourceService;
        this.secretSession = new SecretSession(secretManager);
    }

    @Override
    public abstract T getConfigurationProperties();

    @Override
    public Map<String, Object> getPropertiesMap(String property) {
        ConfigurableEnvironment environment = this.applicationContext.getEnvironment();
        for (PropertySource propertySource : environment.getPropertySources()) {
            BootstrapPropertySource bootstrapPropertySource;
            Map map;
            if (propertySource instanceof BootstrapPropertySource && (map = (Map)propertySource.getSource()).containsKey(property)) {
                return map;
            }
            if (!(propertySource.getSource() instanceof BootstrapPropertySource) || !(bootstrapPropertySource = (BootstrapPropertySource)propertySource.getSource()).containsProperty(property)) continue;
            return (Map)bootstrapPropertySource.getSource();
        }
        throw new RuntimeException("No BootstrapPropertySource found!");
    }

    @Override
    public BindResult<?> bind(Map<String, Object> propertiesMap, Class<?> clazz) {
        this.resolveSpecialCases(propertiesMap);
        MapConfigurationPropertySource configurationPropertySource = new MapConfigurationPropertySource(propertiesMap);
        Iterable sourceIterable = () -> AbstractBootstrapCredentialsConfigurationProvider.lambda$bind$0((ConfigurationPropertySource)configurationPropertySource);
        Binder binder = new Binder(sourceIterable, (PlaceholdersResolver)new PropertySourcesPlaceholdersResolver((Environment)this.applicationContext.getEnvironment()));
        return binder.bind("", Bindable.of(clazz));
    }

    private void resolveSpecialCases(Map<String, Object> propertiesMap) {
        for (Map.Entry<String, Object> entry : propertiesMap.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            String result = this.resolveConfigServerPattern((String)entry.getValue());
            result = this.resolveEncryptedPattern(result);
            entry.setValue(result);
        }
    }

    @Override
    public Map<String, Object> getFlatMap(Map<String, Object> unflatMap) {
        try {
            return JsonFlattener.flattenAsMap((String)this.objectMapper.writeValueAsString(unflatMap));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error occurred while building object: " + e.getMessage());
        }
    }

    private String resolveEncryptedPattern(String possiblePattern) {
        if (possiblePattern.startsWith("encrypted:")) {
            possiblePattern = this.secretSession.decrypt(possiblePattern);
        }
        return possiblePattern;
    }

    private String resolveConfigServerPattern(String possiblePattern) {
        if (possiblePattern.startsWith("configserver:")) {
            possiblePattern = this.resolveConfigServerFilePath(possiblePattern);
        }
        return possiblePattern;
    }

    private String resolveConfigServerFilePath(String key) {
        String filePath;
        if (this.cacheContainsKey(key) && this.resourceExist(filePath = this.configServerCache.get(key))) {
            return filePath;
        }
        filePath = this.configResourceService.getLocalPath(key);
        this.addToCache(key, filePath);
        return filePath;
    }

    private boolean resourceExist(String filePath) {
        return Path.of(filePath, new String[0]).toFile().isFile();
    }

    private void addToCache(String key, String filePath) {
        this.configServerCache.put(key, filePath);
    }

    private boolean cacheContainsKey(String key) {
        if (this.configServerCache == null) {
            this.configServerCache = new HashMap<String, String>();
            return false;
        }
        return this.configServerCache.containsKey(key);
    }

    private static /* synthetic */ Iterator lambda$bind$0(ConfigurationPropertySource configurationPropertySource) {
        return Collections.singleton(configurationPropertySource).iterator();
    }
}

