/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.config;

import com.netflix.spinnaker.kork.annotations.Alpha;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.cloud.context.scope.refresh.RefreshScope;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

@Alpha
public class ModifiableFilePropertySources
implements BeanPostProcessor,
Ordered,
Runnable,
ApplicationListener<ApplicationReadyEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ModifiableFilePropertySources.class);
    private final List<DynamicFilePropertySource> dynamicFilePropertySources;
    private ConfigurableApplicationContext applicationContext;
    private RefreshScope refreshScope;

    public ModifiableFilePropertySources(ConfigurableApplicationContext applicationContext, RefreshScope refreshScope, List<String> dynamicConfigFiles) {
        this.applicationContext = applicationContext;
        this.refreshScope = refreshScope;
        this.dynamicFilePropertySources = dynamicConfigFiles.stream().map(f -> new DynamicFilePropertySource((String)f)).collect(Collectors.toList());
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        Thread t = new Thread((Runnable)this, "dynamicConfig");
        t.setDaemon(true);
        t.start();
    }

    @PostConstruct
    public void start() {
        this.dynamicFilePropertySources.stream().forEach(DynamicFilePropertySource::install);
    }

    private Optional<DynamicFilePropertySource> getDynamicFilePropertySourceFromEvent(Watchable directory, Object context) {
        if (directory instanceof Path) {
            String path = ((Path)directory).resolve(context.toString()).toAbsolutePath().toString();
            return this.dynamicFilePropertySources.stream().filter(f -> f.getAbsFilePath().equals(path)).findFirst();
        }
        return Optional.empty();
    }

    private Set<File> getPropertySourceDirectories() {
        Map<File, List<DynamicFilePropertySource>> directoryMap = this.dynamicFilePropertySources.stream().collect(Collectors.groupingBy(f -> f.getFileSystemResource().getFile().getParentFile()));
        return directoryMap.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            WatchKey key;
            Set<File> directoriesToWatch = this.getPropertySourceDirectories();
            WatchService watchService = FileSystems.getDefault().newWatchService();
            for (File directory : directoriesToWatch) {
                Path path = Paths.get(directory.getAbsolutePath(), new String[0]);
                path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            while ((key = watchService.take()) != null) {
                List<WatchEvent<?>> events = key.pollEvents();
                try {
                    boolean notify = false;
                    for (WatchEvent<?> event : events) {
                        Optional<DynamicFilePropertySource> source = this.getDynamicFilePropertySourceFromEvent(key.watchable(), event.context());
                        if (!source.isPresent()) continue;
                        log.info("Detected changes to {}", (Object)source.get().absFilePath);
                        if (!event.kind().equals(StandardWatchEventKinds.ENTRY_CREATE) && !event.kind().equals(StandardWatchEventKinds.ENTRY_MODIFY) && !event.kind().equals(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                        source.get().sync();
                        notify = true;
                    }
                    if (!notify) continue;
                    this.refreshScope.refreshAll();
                    this.applicationContext.publishEvent((ApplicationEvent)new RefreshScopeRefreshedEvent());
                }
                catch (Exception e) {
                    log.error("Error refreshing dynamic config", (Throwable)e);
                }
                finally {
                    key.reset();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            log.error("Unable to watch dynamic config files", (Throwable)e);
        }
    }

    public int getOrder() {
        return -2147483641;
    }

    class DynamicFilePropertySource {
        private FileSystemResource fileSystemResource;
        private String absFilePath;
        private YamlPropertySourceLoader yamlPropertySourceLoader = new YamlPropertySourceLoader();
        private PropertySource dynamicPropertySource;
        private List<PropertySource<?>> propertySources = new ArrayList();

        public DynamicFilePropertySource(String filename) {
            this.absFilePath = Paths.get(filename, new String[0]).toAbsolutePath().toString();
            this.fileSystemResource = new FileSystemResource(filename);
        }

        public void install() {
            this.sync();
            this.dynamicPropertySource = new EnumerablePropertySource(this.absFilePath){

                public String[] getPropertyNames() {
                    return DynamicFilePropertySource.this.propertySources.stream().filter(s -> s instanceof EnumerablePropertySource).map(s -> ((EnumerablePropertySource)s).getPropertyNames()).reduce(new String[0], ArrayUtils::addAll);
                }

                public Object getProperty(String name) {
                    return DynamicFilePropertySource.this.propertySources.stream().map(s -> s.getProperty(name)).filter(Objects::nonNull).findFirst().orElse(null);
                }
            };
            ModifiableFilePropertySources.this.applicationContext.getEnvironment().getPropertySources().addFirst(this.dynamicPropertySource);
        }

        public void sync() {
            try {
                this.propertySources = this.fileSystemResource.getFile().exists() ? this.yamlPropertySourceLoader.load("dynamic:" + this.absFilePath, (Resource)this.fileSystemResource) : new ArrayList();
            }
            catch (IOException e) {
                log.warn("Unable to load properties from " + this.absFilePath, (Throwable)e);
            }
        }

        @Generated
        public FileSystemResource getFileSystemResource() {
            return this.fileSystemResource;
        }

        @Generated
        public String getAbsFilePath() {
            return this.absFilePath;
        }
    }
}

